/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.Stemmer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.AfterClass;

public abstract class StemmerTestBase
extends LuceneTestCase {
    private static Stemmer stemmer;

    @AfterClass
    public static void afterClass() {
        stemmer = null;
    }

    static void init(String affix, String dictionary) throws IOException, ParseException {
        StemmerTestBase.init(false, affix, dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(boolean ignoreCase, String affix, String ... dictionaries) throws IOException, ParseException {
        if (dictionaries.length == 0) {
            throw new IllegalArgumentException("there must be at least one dictionary");
        }
        InputStream affixStream = StemmerTestBase.class.getResourceAsStream(affix);
        if (affixStream == null) {
            throw new FileNotFoundException("file not found: " + affix);
        }
        Closeable[] dictStreams = new InputStream[dictionaries.length];
        for (int i = 0; i < dictionaries.length; ++i) {
            dictStreams[i] = StemmerTestBase.class.getResourceAsStream(dictionaries[i]);
            if (dictStreams[i] != null) continue;
            throw new FileNotFoundException("file not found: " + dictStreams[i]);
        }
        try {
            Dictionary dictionary = new Dictionary((Directory)new RAMDirectory(), "dictionary", affixStream, Arrays.asList(dictStreams), ignoreCase);
            stemmer = new Stemmer(dictionary);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affixStream});
            IOUtils.closeWhileHandlingException((Closeable[])dictStreams);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affixStream});
        IOUtils.closeWhileHandlingException((Closeable[])dictStreams);
    }

    static void assertStemsTo(String s, String ... expected) {
        StemmerTestBase.assertNotNull((Object)stemmer);
        Arrays.sort(expected);
        List stems = stemmer.stem(s);
        Object[] actual = new String[stems.size()];
        for (int i = 0; i < actual.length; ++i) {
            actual[i] = ((CharsRef)stems.get(i)).toString();
        }
        Arrays.sort(actual);
        StemmerTestBase.assertArrayEquals((String)("expected=" + Arrays.toString(expected) + ",actual=" + Arrays.toString(actual)), (Object[])expected, (Object[])actual);
    }
}

