/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.Stemmer;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.LuceneTestCase;

public class Test64kAffixes
extends LuceneTestCase {
    public void test() throws Exception {
        Path tempDir = Test64kAffixes.createTempDir((String)"64kaffixes");
        Path affix = tempDir.resolve("64kaffixes.aff");
        Path dict = tempDir.resolve("64kaffixes.dic");
        BufferedWriter affixWriter = Files.newBufferedWriter(affix, StandardCharsets.UTF_8, new OpenOption[0]);
        affixWriter.write("SET UTF-8\nFLAG num\nSFX 1 Y 65536\n");
        for (int i = 0; i < 65536; ++i) {
            affixWriter.write("SFX 1 0 " + Integer.toHexString(i) + " .\n");
        }
        affixWriter.write("SFX 2 Y 1\nSFX 2 0 s\n");
        affixWriter.close();
        BufferedWriter dictWriter = Files.newBufferedWriter(dict, StandardCharsets.UTF_8, new OpenOption[0]);
        dictWriter.write("1\ndrink/2\n");
        dictWriter.close();
        try (InputStream affStream = Files.newInputStream(affix, new OpenOption[0]);
             InputStream dictStream = Files.newInputStream(dict, new OpenOption[0]);
             BaseDirectoryWrapper tempDir2 = Test64kAffixes.newDirectory();){
            Dictionary dictionary = new Dictionary((Directory)tempDir2, "dictionary", affStream, dictStream);
            Stemmer stemmer = new Stemmer(dictionary);
            List stems = stemmer.stem("drinks");
            Test64kAffixes.assertEquals((long)1L, (long)stems.size());
            Test64kAffixes.assertEquals((Object)"drink", (Object)((CharsRef)stems.get(0)).toString());
        }
    }
}

