/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import org.apache.lucene.analysis.hunspell.StemmerTestBase;
import org.junit.BeforeClass;

public class TestAlternateCasing
extends StemmerTestBase {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestAlternateCasing.init("alternate-casing.aff", "alternate-casing.dic");
    }

    public void testPossibilities() {
        TestAlternateCasing.assertStemsTo("drink", "drink");
        TestAlternateCasing.assertStemsTo("DR\u0130NK", "drink");
        TestAlternateCasing.assertStemsTo("DRINK", new String[0]);
        TestAlternateCasing.assertStemsTo("drinki", "drink");
        TestAlternateCasing.assertStemsTo("DR\u0130NK\u0130", "drink");
        TestAlternateCasing.assertStemsTo("DR\u0130NKI", new String[0]);
        TestAlternateCasing.assertStemsTo("DRINKI", new String[0]);
        TestAlternateCasing.assertStemsTo("DRINK\u0130", new String[0]);
        TestAlternateCasing.assertStemsTo("idrink", "drink");
        TestAlternateCasing.assertStemsTo("\u0130DR\u0130NK", "drink");
        TestAlternateCasing.assertStemsTo("IDR\u0130NK", new String[0]);
        TestAlternateCasing.assertStemsTo("IDRINK", new String[0]);
        TestAlternateCasing.assertStemsTo("\u0130DRINK", new String[0]);
        TestAlternateCasing.assertStemsTo("idrinki", "drink");
        TestAlternateCasing.assertStemsTo("\u0130DR\u0130NK\u0130", "drink");
        TestAlternateCasing.assertStemsTo("r\u0131ver", "r\u0131ver");
        TestAlternateCasing.assertStemsTo("RIVER", "r\u0131ver");
        TestAlternateCasing.assertStemsTo("R\u0130VER", new String[0]);
        TestAlternateCasing.assertStemsTo("r\u0131ver\u0131", "r\u0131ver");
        TestAlternateCasing.assertStemsTo("RIVERI", "r\u0131ver");
        TestAlternateCasing.assertStemsTo("R\u0130VERI", new String[0]);
        TestAlternateCasing.assertStemsTo("R\u0130VER\u0130", new String[0]);
        TestAlternateCasing.assertStemsTo("RIVER\u0130", new String[0]);
        TestAlternateCasing.assertStemsTo("\u0131r\u0131ver", "r\u0131ver");
        TestAlternateCasing.assertStemsTo("IRIVER", "r\u0131ver");
        TestAlternateCasing.assertStemsTo("IR\u0130VER", new String[0]);
        TestAlternateCasing.assertStemsTo("\u0130R\u0130VER", new String[0]);
        TestAlternateCasing.assertStemsTo("\u0130RIVER", new String[0]);
        TestAlternateCasing.assertStemsTo("\u0131r\u0131ver\u0131", "r\u0131ver");
        TestAlternateCasing.assertStemsTo("IRIVERI", "r\u0131ver");
        TestAlternateCasing.assertStemsTo("Ir\u0131ver\u0131", "r\u0131ver");
    }
}

