/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import org.apache.lucene.analysis.hunspell.StemmerTestBase;
import org.junit.BeforeClass;

public class TestCaseInsensitive
extends StemmerTestBase {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestCaseInsensitive.init(true, "simple.aff", "mixedcase.dic");
    }

    public void testCaseInsensitivity() {
        TestCaseInsensitive.assertStemsTo("lucene", "lucene", "lucen");
        TestCaseInsensitive.assertStemsTo("LuCeNe", "lucene", "lucen");
        TestCaseInsensitive.assertStemsTo("mahoute", "mahout");
        TestCaseInsensitive.assertStemsTo("MaHoUte", "mahout");
    }

    public void testSimplePrefix() {
        TestCaseInsensitive.assertStemsTo("solr", "olr");
    }

    public void testRecursiveSuffix() {
        TestCaseInsensitive.assertStemsTo("abcd", new String[0]);
    }

    public void testAllStems() {
        TestCaseInsensitive.assertStemsTo("ab", "ab");
        TestCaseInsensitive.assertStemsTo("abc", "ab");
        TestCaseInsensitive.assertStemsTo("apach", "apach");
        TestCaseInsensitive.assertStemsTo("apache", "apach");
        TestCaseInsensitive.assertStemsTo("foo", "foo", "foo");
        TestCaseInsensitive.assertStemsTo("food", "foo");
        TestCaseInsensitive.assertStemsTo("foos", "foo");
        TestCaseInsensitive.assertStemsTo("lucen", "lucen");
        TestCaseInsensitive.assertStemsTo("lucene", "lucen", "lucene");
        TestCaseInsensitive.assertStemsTo("mahout", "mahout");
        TestCaseInsensitive.assertStemsTo("mahoute", "mahout");
        TestCaseInsensitive.assertStemsTo("moo", "moo");
        TestCaseInsensitive.assertStemsTo("mood", "moo");
        TestCaseInsensitive.assertStemsTo("olr", "olr");
        TestCaseInsensitive.assertStemsTo("solr", "olr");
    }

    public void testBogusStems() {
        TestCaseInsensitive.assertStemsTo("abs", new String[0]);
        TestCaseInsensitive.assertStemsTo("abe", new String[0]);
        TestCaseInsensitive.assertStemsTo("sab", new String[0]);
        TestCaseInsensitive.assertStemsTo("sapach", new String[0]);
        TestCaseInsensitive.assertStemsTo("sapache", new String[0]);
        TestCaseInsensitive.assertStemsTo("apachee", new String[0]);
        TestCaseInsensitive.assertStemsTo("sfoo", new String[0]);
        TestCaseInsensitive.assertStemsTo("sfoos", new String[0]);
        TestCaseInsensitive.assertStemsTo("fooss", new String[0]);
        TestCaseInsensitive.assertStemsTo("lucenee", new String[0]);
        TestCaseInsensitive.assertStemsTo("solre", new String[0]);
    }
}

