/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.CharSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public class TestDictionary
extends LuceneTestCase {
    public void testSimpleDictionary() throws Exception {
        InputStream affixStream = ((Object)((Object)this)).getClass().getResourceAsStream("simple.aff");
        InputStream dictStream = ((Object)((Object)this)).getClass().getResourceAsStream("simple.dic");
        Directory tempDir = this.getDirectory();
        Dictionary dictionary = new Dictionary(tempDir, "dictionary", affixStream, dictStream);
        TestDictionary.assertEquals((long)3L, (long)dictionary.lookupSuffix((char[])new char[]{'e'}, (int)0, (int)1).length);
        TestDictionary.assertEquals((long)1L, (long)dictionary.lookupPrefix((char[])new char[]{'s'}, (int)0, (int)1).length);
        IntsRef ordList = dictionary.lookupWord(new char[]{'o', 'l', 'r'}, 0, 3);
        TestDictionary.assertNotNull((Object)ordList);
        TestDictionary.assertEquals((long)1L, (long)ordList.length);
        BytesRef ref = new BytesRef();
        dictionary.flagLookup.get(ordList.ints[0], ref);
        char[] flags = Dictionary.decodeFlags((BytesRef)ref);
        TestDictionary.assertEquals((long)1L, (long)flags.length);
        ordList = dictionary.lookupWord(new char[]{'l', 'u', 'c', 'e', 'n'}, 0, 5);
        TestDictionary.assertNotNull((Object)ordList);
        TestDictionary.assertEquals((long)1L, (long)ordList.length);
        dictionary.flagLookup.get(ordList.ints[0], ref);
        flags = Dictionary.decodeFlags((BytesRef)ref);
        TestDictionary.assertEquals((long)1L, (long)flags.length);
        affixStream.close();
        dictStream.close();
        tempDir.close();
    }

    public void testCompressedDictionary() throws Exception {
        InputStream affixStream = ((Object)((Object)this)).getClass().getResourceAsStream("compressed.aff");
        InputStream dictStream = ((Object)((Object)this)).getClass().getResourceAsStream("compressed.dic");
        Directory tempDir = this.getDirectory();
        Dictionary dictionary = new Dictionary(tempDir, "dictionary", affixStream, dictStream);
        TestDictionary.assertEquals((long)3L, (long)dictionary.lookupSuffix((char[])new char[]{'e'}, (int)0, (int)1).length);
        TestDictionary.assertEquals((long)1L, (long)dictionary.lookupPrefix((char[])new char[]{'s'}, (int)0, (int)1).length);
        IntsRef ordList = dictionary.lookupWord(new char[]{'o', 'l', 'r'}, 0, 3);
        BytesRef ref = new BytesRef();
        dictionary.flagLookup.get(ordList.ints[0], ref);
        char[] flags = Dictionary.decodeFlags((BytesRef)ref);
        TestDictionary.assertEquals((long)1L, (long)flags.length);
        affixStream.close();
        dictStream.close();
        tempDir.close();
    }

    public void testCompressedBeforeSetDictionary() throws Exception {
        InputStream affixStream = ((Object)((Object)this)).getClass().getResourceAsStream("compressed-before-set.aff");
        InputStream dictStream = ((Object)((Object)this)).getClass().getResourceAsStream("compressed.dic");
        Directory tempDir = this.getDirectory();
        Dictionary dictionary = new Dictionary(tempDir, "dictionary", affixStream, dictStream);
        TestDictionary.assertEquals((long)3L, (long)dictionary.lookupSuffix((char[])new char[]{'e'}, (int)0, (int)1).length);
        TestDictionary.assertEquals((long)1L, (long)dictionary.lookupPrefix((char[])new char[]{'s'}, (int)0, (int)1).length);
        IntsRef ordList = dictionary.lookupWord(new char[]{'o', 'l', 'r'}, 0, 3);
        BytesRef ref = new BytesRef();
        dictionary.flagLookup.get(ordList.ints[0], ref);
        char[] flags = Dictionary.decodeFlags((BytesRef)ref);
        TestDictionary.assertEquals((long)1L, (long)flags.length);
        affixStream.close();
        dictStream.close();
        tempDir.close();
    }

    public void testCompressedEmptyAliasDictionary() throws Exception {
        InputStream affixStream = ((Object)((Object)this)).getClass().getResourceAsStream("compressed-empty-alias.aff");
        InputStream dictStream = ((Object)((Object)this)).getClass().getResourceAsStream("compressed.dic");
        Directory tempDir = this.getDirectory();
        Dictionary dictionary = new Dictionary(tempDir, "dictionary", affixStream, dictStream);
        TestDictionary.assertEquals((long)3L, (long)dictionary.lookupSuffix((char[])new char[]{'e'}, (int)0, (int)1).length);
        TestDictionary.assertEquals((long)1L, (long)dictionary.lookupPrefix((char[])new char[]{'s'}, (int)0, (int)1).length);
        IntsRef ordList = dictionary.lookupWord(new char[]{'o', 'l', 'r'}, 0, 3);
        BytesRef ref = new BytesRef();
        dictionary.flagLookup.get(ordList.ints[0], ref);
        char[] flags = Dictionary.decodeFlags((BytesRef)ref);
        TestDictionary.assertEquals((long)1L, (long)flags.length);
        affixStream.close();
        dictStream.close();
        tempDir.close();
    }

    public void testInvalidData() throws Exception {
        InputStream affixStream = ((Object)((Object)this)).getClass().getResourceAsStream("broken.aff");
        InputStream dictStream = ((Object)((Object)this)).getClass().getResourceAsStream("simple.dic");
        Directory tempDir = this.getDirectory();
        ParseException expected = (ParseException)TestDictionary.expectThrows(ParseException.class, () -> new Dictionary(tempDir, "dictionary", affixStream, dictStream));
        TestDictionary.assertTrue((boolean)expected.getMessage().startsWith("The affix file contains a rule with less than four elements"));
        TestDictionary.assertEquals((long)24L, (long)expected.getErrorOffset());
        affixStream.close();
        dictStream.close();
        tempDir.close();
    }

    public void testInvalidFlags() throws Exception {
        InputStream affixStream = ((Object)((Object)this)).getClass().getResourceAsStream("broken-flags.aff");
        InputStream dictStream = ((Object)((Object)this)).getClass().getResourceAsStream("simple.dic");
        Directory tempDir = this.getDirectory();
        Exception expected = (Exception)TestDictionary.expectThrows(Exception.class, () -> new Dictionary(tempDir, "dictionary", affixStream, dictStream));
        TestDictionary.assertTrue((boolean)expected.getMessage().startsWith("expected only one flag"));
        affixStream.close();
        dictStream.close();
        tempDir.close();
    }

    public void testResourceCleanup() throws Exception {
        CloseCheckInputStream affixStream = new CloseCheckInputStream(((Object)((Object)this)).getClass().getResourceAsStream("compressed.aff"));
        CloseCheckInputStream dictStream = new CloseCheckInputStream(((Object)((Object)this)).getClass().getResourceAsStream("compressed.dic"));
        Directory tempDir = this.getDirectory();
        new Dictionary(tempDir, "dictionary", (InputStream)affixStream, (InputStream)dictStream);
        TestDictionary.assertFalse((boolean)affixStream.isClosed());
        TestDictionary.assertFalse((boolean)dictStream.isClosed());
        affixStream.close();
        dictStream.close();
        tempDir.close();
        TestDictionary.assertTrue((boolean)affixStream.isClosed());
        TestDictionary.assertTrue((boolean)dictStream.isClosed());
    }

    public void testReplacements() throws Exception {
        CharSequenceOutputs outputs = CharSequenceOutputs.getSingleton();
        Builder builder = new Builder(FST.INPUT_TYPE.BYTE2, (Outputs)outputs);
        IntsRefBuilder scratchInts = new IntsRefBuilder();
        Util.toUTF16((CharSequence)"a", (IntsRefBuilder)scratchInts);
        builder.add(scratchInts.get(), (Object)new CharsRef("b"));
        Util.toUTF16((CharSequence)"ab", (IntsRefBuilder)scratchInts);
        builder.add(scratchInts.get(), (Object)new CharsRef("c"));
        Util.toUTF16((CharSequence)"c", (IntsRefBuilder)scratchInts);
        builder.add(scratchInts.get(), (Object)new CharsRef("de"));
        Util.toUTF16((CharSequence)"def", (IntsRefBuilder)scratchInts);
        builder.add(scratchInts.get(), (Object)new CharsRef("gh"));
        FST fst = builder.finish();
        StringBuilder sb = new StringBuilder("atestanother");
        Dictionary.applyMappings((FST)fst, (StringBuilder)sb);
        TestDictionary.assertEquals((Object)"btestbnother", (Object)sb.toString());
        sb = new StringBuilder("abtestanother");
        Dictionary.applyMappings((FST)fst, (StringBuilder)sb);
        TestDictionary.assertEquals((Object)"ctestbnother", (Object)sb.toString());
        sb = new StringBuilder("atestabnother");
        Dictionary.applyMappings((FST)fst, (StringBuilder)sb);
        TestDictionary.assertEquals((Object)"btestcnother", (Object)sb.toString());
        sb = new StringBuilder("abtestabnother");
        Dictionary.applyMappings((FST)fst, (StringBuilder)sb);
        TestDictionary.assertEquals((Object)"ctestcnother", (Object)sb.toString());
        sb = new StringBuilder("abtestabcnother");
        Dictionary.applyMappings((FST)fst, (StringBuilder)sb);
        TestDictionary.assertEquals((Object)"ctestcdenother", (Object)sb.toString());
        sb = new StringBuilder("defdefdefc");
        Dictionary.applyMappings((FST)fst, (StringBuilder)sb);
        TestDictionary.assertEquals((Object)"ghghghde", (Object)sb.toString());
    }

    public void testSetWithCrazyWhitespaceAndBOMs() throws Exception {
        TestDictionary.assertEquals((Object)"UTF-8", (Object)Dictionary.getDictionaryEncoding((InputStream)new ByteArrayInputStream("SET\tUTF-8\n".getBytes(StandardCharsets.UTF_8))));
        TestDictionary.assertEquals((Object)"UTF-8", (Object)Dictionary.getDictionaryEncoding((InputStream)new ByteArrayInputStream("SET\t UTF-8\n".getBytes(StandardCharsets.UTF_8))));
        TestDictionary.assertEquals((Object)"UTF-8", (Object)Dictionary.getDictionaryEncoding((InputStream)new ByteArrayInputStream("\ufeffSET\tUTF-8\n".getBytes(StandardCharsets.UTF_8))));
        TestDictionary.assertEquals((Object)"UTF-8", (Object)Dictionary.getDictionaryEncoding((InputStream)new ByteArrayInputStream("\ufeffSET\tUTF-8\r\n".getBytes(StandardCharsets.UTF_8))));
    }

    public void testFlagWithCrazyWhitespace() throws Exception {
        TestDictionary.assertNotNull((Object)Dictionary.getFlagParsingStrategy((String)"FLAG\tUTF-8"));
        TestDictionary.assertNotNull((Object)Dictionary.getFlagParsingStrategy((String)"FLAG    UTF-8"));
    }

    private Directory getDirectory() {
        return TestDictionary.newDirectory();
    }

    private static class CloseCheckInputStream
    extends FilterInputStream {
        private boolean closed = false;

        public CloseCheckInputStream(InputStream delegate) {
            super(delegate);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

