/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.lucene.analysis.hunspell.TestStemmer;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestHunspellStemFilter
extends BaseTokenStreamTestCase {
    private static Dictionary dictionary;

    @BeforeClass
    public static void beforeClass() throws Exception {
        InputStream affixStream = TestStemmer.class.getResourceAsStream("simple.aff");
        InputStream dictStream = TestStemmer.class.getResourceAsStream("simple.dic");
        Directory tempDir = TestHunspellStemFilter.getDirectory();
        try {
            dictionary = new Dictionary(tempDir, "dictionary", affixStream, dictStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affixStream, dictStream});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affixStream, dictStream});
        tempDir.close();
    }

    @AfterClass
    public static void afterClass() {
        dictionary = null;
    }

    public void testKeywordAttribute() throws IOException {
        MockTokenizer tokenizer = TestHunspellStemFilter.whitespaceMockTokenizer((String)"lucene is awesome");
        tokenizer.setEnableChecks(true);
        HunspellStemFilter filter = new HunspellStemFilter((TokenStream)tokenizer, dictionary);
        TestHunspellStemFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"lucene", "lucen", "is", "awesome"}, (int[])new int[]{1, 0, 1, 1});
        tokenizer = TestHunspellStemFilter.whitespaceMockTokenizer((String)"lucene is awesome");
        CharArraySet set = new CharArraySet(Arrays.asList("Lucene"), true);
        filter = new HunspellStemFilter((TokenStream)new SetKeywordMarkerFilter((TokenStream)tokenizer, set), dictionary);
        TestHunspellStemFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"lucene", "is", "awesome"}, (int[])new int[]{1, 1, 1});
    }

    public void testLongestOnly() throws IOException {
        MockTokenizer tokenizer = TestHunspellStemFilter.whitespaceMockTokenizer((String)"lucene is awesome");
        tokenizer.setEnableChecks(true);
        HunspellStemFilter filter = new HunspellStemFilter((TokenStream)tokenizer, dictionary, true, true);
        TestHunspellStemFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"lucene", "is", "awesome"}, (int[])new int[]{1, 1, 1});
    }

    public void testRandomStrings() throws Exception {
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new HunspellStemFilter((TokenStream)tokenizer, dictionary));
            }
        };
        TestHunspellStemFilter.checkRandomData((Random)TestHunspellStemFilter.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new HunspellStemFilter((TokenStream)tokenizer, dictionary));
            }
        };
        TestHunspellStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnoreCaseNoSideEffects() throws Exception {
        Dictionary d;
        InputStream affixStream = TestStemmer.class.getResourceAsStream("simple.aff");
        InputStream dictStream = TestStemmer.class.getResourceAsStream("simple.dic");
        Directory tempDir = TestHunspellStemFilter.getDirectory();
        try {
            d = new Dictionary(tempDir, "dictionary", affixStream, Collections.singletonList(dictStream), true);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affixStream, dictStream});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affixStream, dictStream});
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new HunspellStemFilter((TokenStream)tokenizer, d));
            }
        };
        TestHunspellStemFilter.checkOneTerm((Analyzer)a, (String)"NoChAnGy", (String)"NoChAnGy");
        a.close();
        tempDir.close();
    }

    private static Directory getDirectory() {
        return TestHunspellStemFilter.newDirectory();
    }
}

