/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestHunspellStemFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("abc");
        MockTokenizer stream = TestHunspellStemFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("HunspellStem", "dictionary", "simple.dic", "affix", "simple.aff").create((TokenStream)stream);
        TestHunspellStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"ab"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestHunspellStemFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("HunspellStem", "dictionary", "simple.dic", "bogusArg", "bogusValue"));
        TestHunspellStemFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

