/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import org.apache.lucene.analysis.hunspell.StemmerTestBase;
import org.junit.BeforeClass;

public class TestStemmer
extends StemmerTestBase {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestStemmer.init("simple.aff", "simple.dic");
    }

    public void testSimpleSuffix() {
        TestStemmer.assertStemsTo("lucene", "lucene", "lucen");
        TestStemmer.assertStemsTo("mahoute", "mahout");
    }

    public void testSimplePrefix() {
        TestStemmer.assertStemsTo("solr", "olr");
    }

    public void testRecursiveSuffix() {
        TestStemmer.assertStemsTo("abcd", new String[0]);
    }

    public void testAllStems() {
        TestStemmer.assertStemsTo("ab", "ab");
        TestStemmer.assertStemsTo("abc", "ab");
        TestStemmer.assertStemsTo("apach", "apach");
        TestStemmer.assertStemsTo("apache", "apach");
        TestStemmer.assertStemsTo("foo", "foo", "foo");
        TestStemmer.assertStemsTo("food", "foo");
        TestStemmer.assertStemsTo("foos", "foo");
        TestStemmer.assertStemsTo("lucen", "lucen");
        TestStemmer.assertStemsTo("lucene", "lucen", "lucene");
        TestStemmer.assertStemsTo("mahout", "mahout");
        TestStemmer.assertStemsTo("mahoute", "mahout");
        TestStemmer.assertStemsTo("moo", "moo");
        TestStemmer.assertStemsTo("mood", "moo");
        TestStemmer.assertStemsTo("olr", "olr");
        TestStemmer.assertStemsTo("solr", "olr");
    }

    public void testBogusStems() {
        TestStemmer.assertStemsTo("abs", new String[0]);
        TestStemmer.assertStemsTo("abe", new String[0]);
        TestStemmer.assertStemsTo("sab", new String[0]);
        TestStemmer.assertStemsTo("sapach", new String[0]);
        TestStemmer.assertStemsTo("sapache", new String[0]);
        TestStemmer.assertStemsTo("apachee", new String[0]);
        TestStemmer.assertStemsTo("sfoo", new String[0]);
        TestStemmer.assertStemsTo("sfoos", new String[0]);
        TestStemmer.assertStemsTo("fooss", new String[0]);
        TestStemmer.assertStemsTo("lucenee", new String[0]);
        TestStemmer.assertStemsTo("solre", new String[0]);
    }
}

