/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hy;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;

public class TestArmenianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new ArmenianAnalyzer().close();
    }

    public void testBasics() throws IOException {
        ArmenianAnalyzer a = new ArmenianAnalyzer();
        TestArmenianAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0561\u0580\u056e\u056b\u057e", (String)"\u0561\u0580\u056e");
        TestArmenianAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0561\u0580\u056e\u056b\u057e\u0576\u0565\u0580", (String)"\u0561\u0580\u056e");
        TestArmenianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0567", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestArmenianAnalyzer.asSet((Object[])new String[]{"\u0561\u0580\u056e\u056b\u057e\u0576\u0565\u0580"}), false);
        ArmenianAnalyzer a = new ArmenianAnalyzer(ArmenianAnalyzer.getDefaultStopSet(), exclusionSet);
        TestArmenianAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0561\u0580\u056e\u056b\u057e\u0576\u0565\u0580", (String)"\u0561\u0580\u056e\u056b\u057e\u0576\u0565\u0580");
        TestArmenianAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0561\u0580\u056e\u056b\u057e", (String)"\u0561\u0580\u056e");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        ArmenianAnalyzer analyzer = new ArmenianAnalyzer();
        TestArmenianAnalyzer.checkRandomData((Random)TestArmenianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

