/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.id;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;

public class TestIndonesianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new IndonesianAnalyzer().close();
    }

    public void testBasics() throws IOException {
        IndonesianAnalyzer a = new IndonesianAnalyzer();
        TestIndonesianAnalyzer.checkOneTerm((Analyzer)a, (String)"peledakan", (String)"ledak");
        TestIndonesianAnalyzer.checkOneTerm((Analyzer)a, (String)"pembunuhan", (String)"bunuh");
        TestIndonesianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"bahwa", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestIndonesianAnalyzer.asSet((Object[])new String[]{"peledakan"}), false);
        IndonesianAnalyzer a = new IndonesianAnalyzer(IndonesianAnalyzer.getDefaultStopSet(), exclusionSet);
        TestIndonesianAnalyzer.checkOneTerm((Analyzer)a, (String)"peledakan", (String)"peledakan");
        TestIndonesianAnalyzer.checkOneTerm((Analyzer)a, (String)"pembunuhan", (String)"bunuh");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        IndonesianAnalyzer analyzer = new IndonesianAnalyzer();
        TestIndonesianAnalyzer.checkRandomData((Random)TestIndonesianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

