/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.id;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestIndonesianStemFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("dibukukannya");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("IndonesianStem", new String[0]).create((TokenStream)stream);
        TestIndonesianStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"buku"});
    }

    public void testStemmingInflectional() throws Exception {
        StringReader reader = new StringReader("dibukukannya");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("IndonesianStem", "stemDerivational", "false").create((TokenStream)stream);
        TestIndonesianStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"dibukukan"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestIndonesianStemFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("IndonesianStem", "bogusArg", "bogusValue"));
        TestIndonesianStemFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

