/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.id;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.id.IndonesianStemFilter;
import org.apache.lucene.util.IOUtils;

public class TestIndonesianStemmer
extends BaseTokenStreamTestCase {
    private Analyzer a;
    private Analyzer b;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.KEYWORD, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new IndonesianStemFilter((TokenStream)tokenizer));
            }
        };
        this.b = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.KEYWORD, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new IndonesianStemFilter((TokenStream)tokenizer, false));
            }
        };
    }

    public void tearDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.a, this.b});
        super.tearDown();
    }

    public void testExamples() throws IOException {
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bukukah", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"adalah", (String)"ada");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bukupun", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bukuku", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bukumu", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bukunya", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"mengukur", (String)"ukur");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"menyapu", (String)"sapu");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"menduga", (String)"duga");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"menuduh", (String)"uduh");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"membaca", (String)"baca");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"merusak", (String)"rusak");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"pengukur", (String)"ukur");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"penyapu", (String)"sapu");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"penduga", (String)"duga");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"pembaca", (String)"baca");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"diukur", (String)"ukur");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"tersapu", (String)"sapu");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"kekasih", (String)"kasih");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"berlari", (String)"lari");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"belajar", (String)"ajar");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bekerja", (String)"kerja");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"perjelas", (String)"jelas");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"pelajar", (String)"ajar");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"pekerja", (String)"kerja");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"tarikkan", (String)"tarik");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"ambilkan", (String)"ambil");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"mengambilkan", (String)"ambil");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"makanan", (String)"makan");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"janjian", (String)"janji");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"perjanjian", (String)"janji");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"tandai", (String)"tanda");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"dapati", (String)"dapat");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"mendapati", (String)"dapat");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"pantai", (String)"panta");
    }

    public void testIRExamples() throws IOException {
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"penyalahgunaan", (String)"salahguna");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"menyalahgunakan", (String)"salahguna");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"disalahgunakan", (String)"salahguna");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"pertanggungjawaban", (String)"tanggungjawab");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"mempertanggungjawabkan", (String)"tanggungjawab");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"dipertanggungjawabkan", (String)"tanggungjawab");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"pelaksanaan", (String)"laksana");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"pelaksana", (String)"laksana");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"melaksanakan", (String)"laksana");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"dilaksanakan", (String)"laksana");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"melibatkan", (String)"libat");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"terlibat", (String)"libat");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"penculikan", (String)"culik");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"menculik", (String)"culik");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"diculik", (String)"culik");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"penculik", (String)"culik");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"perubahan", (String)"ubah");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"peledakan", (String)"ledak");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"penanganan", (String)"tangan");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"kepolisian", (String)"polisi");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"kenaikan", (String)"naik");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bersenjata", (String)"senjata");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"penyelewengan", (String)"seleweng");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"kecelakaan", (String)"celaka");
    }

    public void testInflectionalOnly() throws IOException {
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.b, (String)"bukunya", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.b, (String)"bukukah", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.b, (String)"bukunyakah", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.b, (String)"dibukukannya", (String)"dibukukan");
    }

    public void testShouldntStem() throws IOException {
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bersenjata", (String)"senjata");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"bukukah", (String)"buku");
        TestIndonesianStemmer.checkOneTerm((Analyzer)this.a, (String)"gigi", (String)"gigi");
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new IndonesianStemFilter((TokenStream)tokenizer));
            }
        };
        TestIndonesianStemmer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

