/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.in;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;

public class TestIndicNormalizer
extends BaseTokenStreamTestCase {
    public void testBasics() throws IOException {
        this.check("\u0905\u093e\u0945\u0905\u093e\u0945", "\u0911\u0911");
        this.check("\u0905\u093e\u0946\u0905\u093e\u0946", "\u0912\u0912");
        this.check("\u0905\u093e\u0947\u0905\u093e\u0947", "\u0913\u0913");
        this.check("\u0905\u093e\u0948\u0905\u093e\u0948", "\u0914\u0914");
        this.check("\u0905\u093e\u0905\u093e", "\u0906\u0906");
        this.check("\u0905\u093e\u0948\u0930", "\u0914\u0930");
        this.check("\u09a4\u09cd\u200d", "\u09ce");
    }

    private void check(String input, String output) throws IOException {
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader(input));
        IndicNormalizationFilter tf = new IndicNormalizationFilter((TokenStream)tokenizer);
        TestIndicNormalizer.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{output});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new IndicNormalizationFilter((TokenStream)tokenizer));
            }
        };
        TestIndicNormalizer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

