/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.it;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.it.ItalianAnalyzer;

public class TestItalianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new ItalianAnalyzer().close();
    }

    public void testBasics() throws IOException {
        ItalianAnalyzer a = new ItalianAnalyzer();
        TestItalianAnalyzer.checkOneTerm((Analyzer)a, (String)"abbandonata", (String)"abbandonat");
        TestItalianAnalyzer.checkOneTerm((Analyzer)a, (String)"abbandonati", (String)"abbandonat");
        TestItalianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"dallo", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestItalianAnalyzer.asSet((Object[])new String[]{"abbandonata"}), false);
        ItalianAnalyzer a = new ItalianAnalyzer(ItalianAnalyzer.getDefaultStopSet(), exclusionSet);
        TestItalianAnalyzer.checkOneTerm((Analyzer)a, (String)"abbandonata", (String)"abbandonata");
        TestItalianAnalyzer.checkOneTerm((Analyzer)a, (String)"abbandonati", (String)"abbandonat");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        ItalianAnalyzer analyzer = new ItalianAnalyzer();
        TestItalianAnalyzer.checkRandomData((Random)TestItalianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }

    public void testContractions() throws IOException {
        ItalianAnalyzer a = new ItalianAnalyzer();
        TestItalianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"dell'Italia", (String[])new String[]{"ital"});
        TestItalianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"l'Italiano", (String[])new String[]{"italian"});
        a.close();
    }
}

