/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.lt;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.lt.LithuanianAnalyzer;

public class TestLithuanianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new LithuanianAnalyzer().close();
    }

    public void testStopWord() throws Exception {
        LithuanianAnalyzer a = new LithuanianAnalyzer();
        TestLithuanianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"man", (String[])new String[0]);
    }

    public void testStemExclusion() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("vaik\u0173");
        LithuanianAnalyzer a = new LithuanianAnalyzer(CharArraySet.EMPTY_SET, set);
        TestLithuanianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"vaik\u0173", (String[])new String[]{"vaik\u0173"});
    }

    public void testRandomStrings() throws Exception {
        TestLithuanianAnalyzer.checkRandomData((Random)TestLithuanianAnalyzer.random(), (Analyzer)new LithuanianAnalyzer(), (int)(1000 * RANDOM_MULTIPLIER));
    }
}

