/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.lt;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.LithuanianStemmer;

public class TestLithuanianStemming
extends BaseTokenStreamTestCase {
    private Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SnowballFilter((TokenStream)tokenizer, (SnowballProgram)new LithuanianStemmer()));
            }
        };
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testNounsI() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaikas", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaikai", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaiko", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaik\u0173", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaikui", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaikams", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaik\u0105", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaikus", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaiku", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaikais", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaike", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaikuose", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaike", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vaikai", (String)"vaik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"brolis", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broliai", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"brolio", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broli\u0173", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broliui", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broliams", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"brol\u012f", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"brolius", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broliu", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broliais", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"brolyje", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broliuose", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broli", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"broliai", (String)"brol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arklys", (String)"arkl");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkliai", (String)"arkliai");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arklio", (String)"arkl");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkli\u0173", (String)"arkl");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkliui", (String)"arkliui");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkliams", (String)"arkliam");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkl\u012f", (String)"arkl");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arklius", (String)"arklius");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkliu", (String)"arkl");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkliais", (String)"arkliais");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arklyje", (String)"arklyj");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkliuose", (String)"arkliuos");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkly", (String)"arkl");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arkliai", (String)"arkliai");
    }

    public void testNounsII() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motina", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinos", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinos", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motin\u0173", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinai", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinoms", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motin\u0105", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinas", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motina", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinomis", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinoje", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinose", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motina", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"motinos", (String)"motin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0117", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0117s", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0117s", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ka\u010di\u0173", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"katei", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0117ms", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0119", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kates", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kate", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0117mis", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0117je", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0117se", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kate", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kat\u0117s", (String)"kat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pati", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010dios", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010dios", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010di\u0173", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010diai", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010dioms", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010di\u0105", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010dias", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010dia", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010diomis", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010dioje", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010diose", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pati", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pa\u010dios", (String)"pat");
    }

    public void testNounsIII() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagis", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagys", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagies", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagi\u0173", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagiui", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagims", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vag\u012f", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagis", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagimi", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagimis", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagyje", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagyse", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagie", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vagys", (String)"vag");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akis", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akys", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akies", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"aki\u0173", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akiai", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akims", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ak\u012f", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akis", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akimi", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akimis", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akyje", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akyse", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akie", (String)"ak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"akys", (String)"ak");
    }

    public void testNounsIV() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnus", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bn\u016bs", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnaus", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bn\u0173", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnui", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnums", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bn\u0173", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnus", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnumi", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnumis", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnuje", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnuose", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bnau", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"s\u016bn\u016bs", (String)"s\u016bn");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesorius", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriai", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriaus", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesori\u0173", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriui", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriams", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesori\u0173", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesorius", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriumi", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriais", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriuje", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriuose", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriau", (String)"profesor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"profesoriai", (String)"profesor");
    }

    public void testNounsV() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vanduo", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandenys", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandens", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vanden\u0173", (String)"vanden");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandeniui", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandenims", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vanden\u012f", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandenis", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandeniu", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandenimis", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandenyje", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandenyse", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandenie", (String)"vand");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vandenys", (String)"vand");
    }

    public void testAdjI() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geras", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geri", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gero", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ger\u0173", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geram", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geriems", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ger\u0105", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gerus", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geru", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gerais", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gerame", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geruose", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gera", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geros", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geros", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ger\u0173", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gerai", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geroms", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ger\u0105", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geras", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gera", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geromis", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"geroje", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gerose", (String)"ger");
    }

    public void testAdjII() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eus", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017e\u016bs", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eaus", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017ei\u0173", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiam", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiems", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017e\u0173", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eius", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiu", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiais", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiame", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiuose", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017ei", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eios", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eios", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017ei\u0173", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiai", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eioms", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017ei\u0105", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eias", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eia", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiomis", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eioje", (String)"gra\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gra\u017eiose", (String)"gra\u017e");
    }

    public void testAdjIII() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutinis", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutiniai", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutinio", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutini\u0173", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutiniam", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutiniams", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u012f", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutinius", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutiniu", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutiniais", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutiniame", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutiniuose", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u0117", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u0117s", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u0117s", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutini\u0173", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutinei", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u0117ms", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u0119", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutines", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutine", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u0117mis", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u0117je", (String)"vidutin");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vidutin\u0117se", (String)"vidutin");
    }

    public void testHighFrequencyTerms() throws IOException {
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ir", (String)"ir");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kad", (String)"kad");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"\u012f", (String)"\u012f");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tai", (String)"tai");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"su", (String)"su");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"o", (String)"o");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"i\u0161", (String)"i\u0161");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kaip", (String)"kaip");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"bet", (String)"bet");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"yra", (String)"yr");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"buvo", (String)"buv");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tik", (String)"tik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ne", (String)"ne");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"taip", (String)"taip");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ar", (String)"ar");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"dar", (String)"dar");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jau", (String)"jau");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"savo", (String)"sav");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"apie", (String)"ap");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kai", (String)"kai");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"a\u0161", (String)"a\u0161");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"per", (String)"per");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"nuo", (String)"nuo");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"po", (String)"po");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jis", (String)"jis");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kas", (String)"kas");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"d", (String)"d");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"labai", (String)"lab");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"man", (String)"man");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"d\u0117l", (String)"d\u0117l");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ta\u010diau", (String)"tat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"nes", (String)"nes");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"u\u017e", (String)"u\u017e");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"to", (String)"to");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jo", (String)"jo");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"iki", (String)"ik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"k\u0105", (String)"k\u0105");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"mano", (String)"man");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"met\u0173", (String)"met");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"nors", (String)"nor");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jei", (String)"jei");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"bus", (String)"bus");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"j\u0173", (String)"j\u0173");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"\u010dia", (String)"\u010dia");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"dabar", (String)"dabar");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"Lietuvos", (String)"Lietuv");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"net", (String)"net");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"nei", (String)"nei");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gali", (String)"gal");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"daug", (String)"daug");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"prie", (String)"prie");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ji", (String)"ji");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jos", (String)"jos");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pat", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jie", (String)"jie");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kur", (String)"kur");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gal", (String)"gal");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ant", (String)"ant");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tiek", (String)"tiek");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"be", (String)"be");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"b\u016bti", (String)"b\u016bt");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"bei", (String)"bei");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"daugiau", (String)"daug");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"turi", (String)"tur");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"prie\u0161", (String)"prie\u0161");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vis", (String)"vis");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"b\u016bt\u0173", (String)"b\u016bt");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jog", (String)"jog");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"reikia", (String)"reik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"m\u016bs\u0173", (String)"m\u016bs");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"metu", (String)"met");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"galima", (String)"galim");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"n\u0117ra", (String)"n\u0117r");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"arba", (String)"arb");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"mes", (String)"mes");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kurie", (String)"kur");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tikrai", (String)"tikr");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tod\u0117l", (String)"tod");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ten", (String)"ten");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"\u0161iandien", (String)"\u0161iandien");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vienas", (String)"vien");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"visi", (String)"vis");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kuris", (String)"kur");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tada", (String)"tad");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kiek", (String)"kiek");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tuo", (String)"tuo");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"gerai", (String)"ger");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"nieko", (String)"niek");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"j\u012f", (String)"j\u012f");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kol", (String)"kol");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"viskas", (String)"visk");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"mane", (String)"man");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kart\u0105", (String)"kart");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"m", (String)"m");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tas", (String)"tas");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"sak\u0117", (String)"sak");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"\u017emoni\u0173", (String)"\u017emon");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tu", (String)"tu");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"dien\u0105", (String)"dien");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"\u017emon\u0117s", (String)"\u017emon");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"metais", (String)"met");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vien\u0105", (String)"vien");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"v\u0117l", (String)"v\u0117l");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"na", (String)"na");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"t\u0105", (String)"t\u0105");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tiesiog", (String)"tiesiog");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"toks", (String)"tok");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pats", (String)"pat");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"ko", (String)"ko");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"Lietuvoje", (String)"Lietuv");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pagal", (String)"pagal");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jeigu", (String)"jeig");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"visai", (String)"vis");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"viena", (String)"vien");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"\u0161\u012f", (String)"\u0161\u012f");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"metus", (String)"met");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"jam", (String)"jam");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kod\u0117l", (String)"kod");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"lit\u0173", (String)"lit");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"j\u0105", (String)"j\u0105");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kuri", (String)"kur");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"darbo", (String)"darb");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tarp", (String)"tarp");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"juk", (String)"juk");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"laiko", (String)"laik");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"juos", (String)"juos");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"vis\u0105", (String)"vis");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kurios", (String)"kur");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tam", (String)"tam");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"pas", (String)"pas");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"visk\u0105", (String)"visk");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"Europos", (String)"Eur");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"atrodo", (String)"atrod");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tad", (String)"tad");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"bent", (String)"bent");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kit\u0173", (String)"kit");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"\u0161is", (String)"\u0161is");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"Vilniaus", (String)"Viln");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"beveik", (String)"bevei");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"proc", (String)"proc");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"tokia", (String)"tok");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"\u0161iuo", (String)"\u0161iuo");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"du", (String)"du");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kartu", (String)"kart");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"visada", (String)"visad");
        TestLithuanianStemming.checkOneTerm((Analyzer)this.a, (String)"kuo", (String)"kuo");
    }
}

