/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.lv;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;

public class TestLatvianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new LatvianAnalyzer().close();
    }

    public void testBasics() throws IOException {
        LatvianAnalyzer a = new LatvianAnalyzer();
        TestLatvianAnalyzer.checkOneTerm((Analyzer)a, (String)"tirgiem", (String)"tirg");
        TestLatvianAnalyzer.checkOneTerm((Analyzer)a, (String)"tirgus", (String)"tirg");
        TestLatvianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"un", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestLatvianAnalyzer.asSet((Object[])new String[]{"tirgiem"}), false);
        LatvianAnalyzer a = new LatvianAnalyzer(LatvianAnalyzer.getDefaultStopSet(), exclusionSet);
        TestLatvianAnalyzer.checkOneTerm((Analyzer)a, (String)"tirgiem", (String)"tirgiem");
        TestLatvianAnalyzer.checkOneTerm((Analyzer)a, (String)"tirgus", (String)"tirg");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        LatvianAnalyzer analyzer = new LatvianAnalyzer();
        TestLatvianAnalyzer.checkRandomData((Random)TestLatvianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

