/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.lv;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.lv.LatvianStemFilter;

public class TestLatvianStemmer
extends BaseTokenStreamTestCase {
    private Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LatvianStemFilter((TokenStream)tokenizer));
            }
        };
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testNouns1() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vs", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vi", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113va", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vu", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vam", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113viem", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vu", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vus", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113v\u0101", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vos", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vs", (String)"t\u0113v");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"t\u0113vi", (String)"t\u0113v");
    }

    public void testNouns2() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101cis", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101\u010di", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101\u010da", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101\u010du", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101cim", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101\u010diem", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101ci", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101\u010dus", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101c\u012b", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101\u010dos", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101ci", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"l\u0101\u010di", (String)"l\u0101c");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akmens", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akme\u0146i", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akmens", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akme\u0146u", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akmenim", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akme\u0146iem", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akmeni", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akme\u0146us", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akmen\u012b", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akme\u0146os", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akmens", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"akme\u0146i", (String)"akmen");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmis", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmji", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmja", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmju", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmim", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmjiem", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmi", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmjus", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurm\u012b", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmjos", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmi", (String)"kurm");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kurmji", (String)"kurm");
    }

    public void testNouns3() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietus", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lieti", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietus", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietu", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietum", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietiem", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietu", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietus", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"liet\u016b", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietos", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lietus", (String)"liet");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lieti", (String)"liet");
    }

    public void testNouns4() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapa", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapas", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapas", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapu", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapai", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lap\u0101m", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapu", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapas", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lap\u0101", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lap\u0101s", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapa", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lapas", (String)"lap");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puika", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puikas", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puikas", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puiku", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puikam", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puik\u0101m", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puiku", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puikas", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puik\u0101", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puik\u0101s", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puika", (String)"puik");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"puikas", (String)"puik");
    }

    public void testNouns5() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egle", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egles", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egles", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"eg\u013cu", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"eglei", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egl\u0113m", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egli", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egles", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egl\u0113", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egl\u0113s", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egle", (String)"egl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"egles", (String)"egl");
    }

    public void testNouns6() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govs", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govis", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govs", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govju", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govij", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"gov\u012bm", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govi ", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govis", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govi ", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"gov\u012bm", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"gov\u012b", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"gov\u012bs", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govs", (String)"gov");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"govis", (String)"gov");
    }

    public void testAdjectives() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zils", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilais", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zili", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilie", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zila", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilas", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101s", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zila", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilu", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilo", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilas", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101s", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilu", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilo", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilam", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilajam", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"ziliem", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilajiem", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilai", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilajai", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101m", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilaj\u0101m", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilu", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilo", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilus", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilos", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilu", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilo", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101s", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101s", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilaj\u0101", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilos", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilajos", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilaj\u0101", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101s", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilaj\u0101s", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilais", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zilie", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101", (String)"zil");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zil\u0101s", (String)"zil");
    }

    public void testPalatalization() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kr\u0101sns", (String)"kr\u0101sn");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"kr\u0101\u0161\u0146u", (String)"kr\u0101sn");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zvaigzne", (String)"zvaigzn");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zvaig\u017e\u0146u", (String)"zvaigzn");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"k\u0101pslis", (String)"k\u0101psl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"k\u0101p\u0161\u013cu", (String)"k\u0101psl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zizlis", (String)"zizl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"zi\u017e\u013cu", (String)"zizl");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"vilnis", (String)"viln");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"vi\u013c\u0146u", (String)"viln");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"lelle", (String)"lell");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"le\u013c\u013cu", (String)"lell");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"pinne", (String)"pinn");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"pi\u0146\u0146u", (String)"pinn");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"r\u012bkste", (String)"r\u012bkst");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"r\u012bk\u0161u", (String)"r\u012bkst");
    }

    public void testLength() throws IOException {
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"usa", (String)"usa");
        TestLatvianStemmer.checkOneTerm((Analyzer)this.a, (String)"60ms", (String)"60ms");
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LatvianStemFilter((TokenStream)tokenizer));
            }
        };
        TestLatvianStemmer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

