/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class TestAsciiFoldingFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testMultiTermAnalysis() throws IOException {
        ASCIIFoldingFilterFactory factory = new ASCIIFoldingFilterFactory(Collections.emptyMap());
        CannedTokenStream stream = new CannedTokenStream(new Token[]{new Token((CharSequence)"\u00c9t\u00e9", 0, 3)});
        stream = factory.create((TokenStream)stream);
        TestAsciiFoldingFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Ete"});
        factory = (TokenFilterFactory)((MultiTermAwareComponent)factory).getMultiTermComponent();
        stream = new CannedTokenStream(new Token[]{new Token((CharSequence)"\u00c9t\u00e9", 0, 3)});
        stream = factory.create((TokenStream)stream);
        TestAsciiFoldingFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Ete"});
        factory = new ASCIIFoldingFilterFactory(new HashMap<String, String>(Collections.singletonMap("preserveOriginal", "true")));
        stream = new CannedTokenStream(new Token[]{new Token((CharSequence)"\u00c9t\u00e9", 0, 3)});
        stream = factory.create((TokenStream)stream);
        TestAsciiFoldingFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Ete", "\u00c9t\u00e9"});
        factory = (TokenFilterFactory)((MultiTermAwareComponent)factory).getMultiTermComponent();
        stream = new CannedTokenStream(new Token[]{new Token((CharSequence)"\u00c9t\u00e9", 0, 3)});
        stream = factory.create((TokenStream)stream);
        TestAsciiFoldingFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Ete"});
    }
}

