/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.CapitalizationFilter;
import org.junit.Test;

public class TestCapitalizationFilter
extends BaseTokenStreamTestCase {
    public void testCapitalization() throws Exception {
        CharArraySet keep = new CharArraySet(Arrays.asList("and", "the", "it", "BIG"), false);
        TestCapitalizationFilter.assertCapitalizesTo("kiTTEN", new String[]{"Kitten"}, true, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("and", new String[]{"And"}, true, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("AnD", new String[]{"And"}, true, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("AnD", new String[]{"And"}, true, keep, false, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("big", new String[]{"Big"}, true, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("BIG", new String[]{"BIG"}, true, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesToKeyword("Hello thEre my Name is Ryan", "Hello there my name is ryan", true, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("Hello thEre my Name is Ryan", new String[]{"Hello", "There", "My", "Name", "Is", "Ryan"}, false, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("Hello thEre my Name is Ryan", new String[]{"Hello", "There", "my", "Name", "is", "Ryan"}, false, keep, true, null, 3, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("McKinley", new String[]{"Mckinley"}, true, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        ArrayList<char[]> okPrefix = new ArrayList<char[]>();
        okPrefix.add("McK".toCharArray());
        TestCapitalizationFilter.assertCapitalizesTo("McKinley", new String[]{"McKinley"}, true, keep, true, okPrefix, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesTo("1st 2nd third", new String[]{"1st", "2nd", "Third"}, false, keep, false, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        TestCapitalizationFilter.assertCapitalizesToKeyword("the The the", "The The the", false, keep, true, null, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    static void assertCapitalizesTo(Tokenizer tokenizer, String[] expected, boolean onlyFirstWord, CharArraySet keep, boolean forceFirstLetter, Collection<char[]> okPrefix, int minWordLength, int maxWordCount, int maxTokenLength) throws IOException {
        CapitalizationFilter filter = new CapitalizationFilter((TokenStream)tokenizer, onlyFirstWord, keep, forceFirstLetter, okPrefix, minWordLength, maxWordCount, maxTokenLength);
        TestCapitalizationFilter.assertTokenStreamContents((TokenStream)filter, (String[])expected);
    }

    static void assertCapitalizesTo(String input, String[] expected, boolean onlyFirstWord, CharArraySet keep, boolean forceFirstLetter, Collection<char[]> okPrefix, int minWordLength, int maxWordCount, int maxTokenLength) throws IOException {
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader(input));
        TestCapitalizationFilter.assertCapitalizesTo((Tokenizer)tokenizer, expected, onlyFirstWord, keep, forceFirstLetter, okPrefix, minWordLength, maxWordCount, maxTokenLength);
    }

    static void assertCapitalizesToKeyword(String input, String expected, boolean onlyFirstWord, CharArraySet keep, boolean forceFirstLetter, Collection<char[]> okPrefix, int minWordLength, int maxWordCount, int maxTokenLength) throws IOException {
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.KEYWORD, false);
        tokenizer.setReader((Reader)new StringReader(input));
        TestCapitalizationFilter.assertCapitalizesTo((Tokenizer)tokenizer, new String[]{expected}, onlyFirstWord, keep, forceFirstLetter, okPrefix, minWordLength, maxWordCount, maxTokenLength);
    }

    public void testRandomString() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CapitalizationFilter((TokenStream)tokenizer));
            }
        };
        TestCapitalizationFilter.checkRandomData((Random)TestCapitalizationFilter.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CapitalizationFilter((TokenStream)tokenizer));
            }
        };
        TestCapitalizationFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArguments() throws Exception {
        new CapitalizationFilter((TokenStream)TestCapitalizationFilter.whitespaceMockTokenizer((String)"accept only valid arguments"), true, null, true, null, -1, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArguments1() throws Exception {
        new CapitalizationFilter((TokenStream)TestCapitalizationFilter.whitespaceMockTokenizer((String)"accept only valid arguments"), true, null, true, null, 0, -10, Integer.MAX_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArguments2() throws Exception {
        new CapitalizationFilter((TokenStream)TestCapitalizationFilter.whitespaceMockTokenizer((String)"accept only valid arguments"), true, null, true, null, 0, Integer.MAX_VALUE, -50);
    }
}

