/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestCapitalizationFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testCapitalization() throws Exception {
        StringReader reader = new StringReader("kiTTEN");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Kitten"});
    }

    public void testCapitalization2() throws Exception {
        StringReader reader = new StringReader("and");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "true", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"And"});
    }

    public void testCapitalization3() throws Exception {
        StringReader reader = new StringReader("AnD");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "true", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"And"});
    }

    public void testCapitalization4() throws Exception {
        StringReader reader = new StringReader("AnD");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "true", "forceFirstLetter", "false").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"And"});
    }

    public void testCapitalization5() throws Exception {
        StringReader reader = new StringReader("big");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "true", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Big"});
    }

    public void testCapitalization6() throws Exception {
        StringReader reader = new StringReader("BIG");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "true", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"BIG"});
    }

    public void testCapitalization7() throws Exception {
        StringReader reader = new StringReader("Hello thEre my Name is Ryan");
        MockTokenizer stream = TestCapitalizationFilterFactory.keywordMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "true", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Hello there my name is ryan"});
    }

    public void testCapitalization8() throws Exception {
        StringReader reader = new StringReader("Hello thEre my Name is Ryan");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "false", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Hello", "There", "My", "Name", "Is", "Ryan"});
    }

    public void testCapitalization9() throws Exception {
        StringReader reader = new StringReader("Hello thEre my Name is Ryan");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "false", "minWordLength", "3", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Hello", "There", "my", "Name", "is", "Ryan"});
    }

    public void testCapitalization10() throws Exception {
        StringReader reader = new StringReader("McKinley");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "false", "minWordLength", "3", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Mckinley"});
    }

    public void testCapitalization11() throws Exception {
        StringReader reader = new StringReader("McKinley");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "false", "minWordLength", "3", "okPrefix", "McK", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"McKinley"});
    }

    public void testCapitalization12() throws Exception {
        StringReader reader = new StringReader("1st 2nd third");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "false", "minWordLength", "3", "okPrefix", "McK", "forceFirstLetter", "false").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"1st", "2nd", "Third"});
    }

    public void testCapitalization13() throws Exception {
        StringReader reader = new StringReader("the The the");
        MockTokenizer stream = TestCapitalizationFilterFactory.keywordMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "false", "minWordLength", "3", "okPrefix", "McK", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"The The the"});
    }

    public void testKeepIgnoreCase() throws Exception {
        StringReader reader = new StringReader("kiTTEN");
        MockTokenizer stream = TestCapitalizationFilterFactory.keywordMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "kitten", "keepIgnoreCase", "true", "onlyFirstWord", "true", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"KiTTEN"});
    }

    public void testKeepIgnoreCase2() throws Exception {
        StringReader reader = new StringReader("kiTTEN");
        MockTokenizer stream = TestCapitalizationFilterFactory.keywordMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "kitten", "keepIgnoreCase", "true", "onlyFirstWord", "true", "forceFirstLetter", "false").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"kiTTEN"});
    }

    public void testKeepIgnoreCase3() throws Exception {
        StringReader reader = new StringReader("kiTTEN");
        MockTokenizer stream = TestCapitalizationFilterFactory.keywordMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keepIgnoreCase", "true", "onlyFirstWord", "true", "forceFirstLetter", "false").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Kitten"});
    }

    public void testMinWordLength() throws Exception {
        StringReader reader = new StringReader("helo testing");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "onlyFirstWord", "true", "minWordLength", "5").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"helo", "Testing"});
    }

    public void testMaxWordCount() throws Exception {
        StringReader reader = new StringReader("one two three four");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "maxWordCount", "2").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"One", "Two", "Three", "Four"});
    }

    public void testMaxWordCount2() throws Exception {
        StringReader reader = new StringReader("one two three four");
        MockTokenizer stream = TestCapitalizationFilterFactory.keywordMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "maxWordCount", "2").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"one two three four"});
    }

    public void testMaxTokenLength() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "maxTokenLength", "2").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this", "is", "A", "test"});
    }

    public void testForceFirstLetterWithKeep() throws Exception {
        StringReader reader = new StringReader("kitten");
        MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Capitalization", "keep", "kitten", "forceFirstLetter", "true").create((TokenStream)stream);
        TestCapitalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Kitten"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestCapitalizationFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Capitalization", "bogusArg", "bogusValue"));
        TestCapitalizationFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }

    public void testInvalidArguments() throws Exception {
        for (String arg : new String[]{"minWordLength", "maxTokenLength", "maxWordCount"}) {
            IllegalArgumentException expected = (IllegalArgumentException)TestCapitalizationFilterFactory.expectThrows(IllegalArgumentException.class, () -> {
                StringReader reader = new StringReader("foo foobar super-duper-trooper");
                MockTokenizer stream = TestCapitalizationFilterFactory.whitespaceMockTokenizer((Reader)reader);
                this.tokenFilterFactory("Capitalization", "keep", "and the it BIG", "onlyFirstWord", "false", arg, "-3", "okPrefix", "McK", "forceFirstLetter", "true").create((TokenStream)stream);
            });
            TestCapitalizationFilterFactory.assertTrue((expected.getMessage().contains(arg + " must be greater than or equal to zero") || expected.getMessage().contains(arg + " must be greater than zero") ? 1 : 0) != 0);
        }
    }
}

