/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.CodepointCountFilter;
import org.apache.lucene.util.TestUtil;
import org.junit.Test;

public class TestCodepointCountFilter
extends BaseTokenStreamTestCase {
    public void testFilterWithPosIncr() throws Exception {
        MockTokenizer stream = TestCodepointCountFilter.whitespaceMockTokenizer((String)"short toolong evenmuchlongertext a ab toolong foo");
        CodepointCountFilter filter = new CodepointCountFilter((TokenStream)stream, 2, 6);
        TestCodepointCountFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"short", "ab", "foo"}, (int[])new int[]{1, 4, 2});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CodepointCountFilter((TokenStream)tokenizer, 0, 5));
            }
        };
        TestCodepointCountFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    public void testRandomStrings() throws IOException {
        for (int i = 0; i < 10000; ++i) {
            String text = TestUtil.randomUnicodeString((Random)TestCodepointCountFilter.random(), (int)100);
            int min = TestUtil.nextInt((Random)TestCodepointCountFilter.random(), (int)0, (int)100);
            int max = TestUtil.nextInt((Random)TestCodepointCountFilter.random(), (int)0, (int)100);
            int count = text.codePointCount(0, text.length());
            if (min > max) {
                int temp = min;
                min = max;
                max = temp;
            }
            boolean expected = count >= min && count <= max;
            KeywordTokenizer stream = new KeywordTokenizer();
            ((Tokenizer)stream).setReader((Reader)new StringReader(text));
            stream = new CodepointCountFilter((TokenStream)stream, min, max);
            stream.reset();
            TestCodepointCountFilter.assertEquals((Object)expected, (Object)stream.incrementToken());
            stream.end();
            stream.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArguments() throws Exception {
        new CodepointCountFilter((TokenStream)TestCodepointCountFilter.whitespaceMockTokenizer((String)"accept only valid arguments"), 4, 1);
    }
}

