/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestCodepointCountFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testPositionIncrements() throws Exception {
        StringReader reader = new StringReader("foo foobar super-duper-trooper");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("CodepointCount", "min", "4", "max", "10").create((TokenStream)stream);
        TestCodepointCountFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"foobar"}, (int[])new int[]{2});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestCodepointCountFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("CodepointCount", "min", "4", "max", "5", "bogusArg", "bogusValue"));
        TestCodepointCountFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }

    public void testInvalidArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestCodepointCountFilterFactory.expectThrows(IllegalArgumentException.class, () -> {
            StringReader reader = new StringReader("foo foobar super-duper-trooper");
            MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
            ((Tokenizer)stream).setReader((Reader)reader);
            this.tokenFilterFactory("CodepointCount", "min", "5", "max", "4").create((TokenStream)stream);
        });
        TestCodepointCountFilterFactory.assertTrue((boolean)expected.getMessage().contains("maximum length must not be greater than minimum length"));
    }
}

