/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.EmptyTokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;

public class TestEmptyTokenStream
extends BaseTokenStreamTestCase {
    public void testConsume() throws IOException {
        EmptyTokenStream ts = new EmptyTokenStream();
        ts.reset();
        TestEmptyTokenStream.assertFalse((boolean)ts.incrementToken());
        ts.end();
        ts.close();
        ts.reset();
        TestEmptyTokenStream.assertFalse((boolean)ts.incrementToken());
        ts.end();
        ts.close();
    }

    public void testConsume2() throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents((TokenStream)new EmptyTokenStream(), (String[])new String[0]);
    }

    public void testIndexWriter_LUCENE4656() throws IOException {
        BaseDirectoryWrapper directory = TestEmptyTokenStream.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)directory, TestEmptyTokenStream.newIndexWriterConfig(null));
        EmptyTokenStream ts = new EmptyTokenStream();
        TestEmptyTokenStream.assertFalse((boolean)ts.hasAttribute(TermToBytesRefAttribute.class));
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new TextField("description", (TokenStream)ts));
        writer.addDocument((Iterable)doc);
        TestEmptyTokenStream.assertEquals((long)1L, (long)writer.numDocs());
        writer.close();
        directory.close();
    }
}

