/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.FingerprintFilter;

public class TestFingerprintFilter
extends BaseTokenStreamTestCase {
    public void testDupsAndSorting() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockTokenizer tokenizer = TestFingerprintFilter.whitespaceMockTokenizer((String)"B A B E");
            tokenizer.setEnableChecks(consumeAll);
            FingerprintFilter stream = new FingerprintFilter((TokenStream)tokenizer);
            TestFingerprintFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"A B E"});
        }
    }

    public void testAllDupValues() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockTokenizer tokenizer = TestFingerprintFilter.whitespaceMockTokenizer((String)"B2 B2");
            tokenizer.setEnableChecks(consumeAll);
            FingerprintFilter stream = new FingerprintFilter((TokenStream)tokenizer);
            TestFingerprintFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"B2"});
        }
    }

    public void testMaxFingerprintSize() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockTokenizer tokenizer = TestFingerprintFilter.whitespaceMockTokenizer((String)"B2 A1 C3 D4 E5 F6 G7 H1");
            tokenizer.setEnableChecks(consumeAll);
            FingerprintFilter stream = new FingerprintFilter((TokenStream)tokenizer, 4, ' ');
            TestFingerprintFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[0]);
        }
    }

    public void testCustomSeparator() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockTokenizer tokenizer = TestFingerprintFilter.whitespaceMockTokenizer((String)"B2 A1 C3 B2");
            tokenizer.setEnableChecks(consumeAll);
            FingerprintFilter stream = new FingerprintFilter((TokenStream)tokenizer, 1024, '_');
            TestFingerprintFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"A1_B2_C3"});
        }
    }

    public void testSingleToken() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockTokenizer tokenizer = TestFingerprintFilter.whitespaceMockTokenizer((String)"A1");
            tokenizer.setEnableChecks(consumeAll);
            FingerprintFilter stream = new FingerprintFilter((TokenStream)tokenizer);
            TestFingerprintFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"A1"});
        }
    }
}

