/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestFingerprintFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void test() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            StringReader reader = new StringReader("A1 B2 A1 D4 C3");
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
            tokenizer.setReader((Reader)reader);
            tokenizer.setEnableChecks(consumeAll);
            MockTokenizer stream = tokenizer;
            stream = this.tokenFilterFactory("Fingerprint", "maxOutputTokenSize", "256", "separator", "_").create((TokenStream)stream);
            TestFingerprintFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"A1_B2_C3_D4"});
        }
    }

    public void testRequired() throws Exception {
        this.tokenFilterFactory("Fingerprint", new String[0]);
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestFingerprintFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Fingerprint", "maxOutputTokenSize", "3", "bogusArg", "bogusValue"));
        TestFingerprintFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

