/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.HyphenatedWordsFilter;

public class TestHyphenatedWordsFilter
extends BaseTokenStreamTestCase {
    public void testHyphenatedWords() throws Exception {
        String input = "ecologi-\r\ncal devel-\r\n\r\nop compre-\thensive-hands-on and ecologi-\ncal";
        MockTokenizer ts = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)ts).setReader((Reader)new StringReader(input));
        ts = new HyphenatedWordsFilter((TokenStream)ts);
        TestHyphenatedWordsFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"ecological", "develop", "comprehensive-hands-on", "and", "ecological"});
    }

    public void testHyphenAtEnd() throws Exception {
        String input = "ecologi-\r\ncal devel-\r\n\r\nop compre-\thensive-hands-on and ecology-";
        MockTokenizer ts = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)ts).setReader((Reader)new StringReader(input));
        ts = new HyphenatedWordsFilter((TokenStream)ts);
        TestHyphenatedWordsFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"ecological", "develop", "comprehensive-hands-on", "and", "ecology-"});
    }

    public void testOffsets() throws Exception {
        String input = "abc- def geh 1234- 5678-";
        MockTokenizer ts = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)ts).setReader((Reader)new StringReader(input));
        ts = new HyphenatedWordsFilter((TokenStream)ts);
        TestHyphenatedWordsFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"abcdef", "geh", "12345678-"}, (int[])new int[]{0, 9, 13}, (int[])new int[]{8, 12, 24});
    }

    public void testRandomString() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new HyphenatedWordsFilter((TokenStream)tokenizer));
            }
        };
        TestHyphenatedWordsFilter.checkRandomData((Random)TestHyphenatedWordsFilter.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new HyphenatedWordsFilter((TokenStream)tokenizer));
            }
        };
        TestHyphenatedWordsFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

