/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.miscellaneous.KeepWordFilterFactory;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;

public class TestKeepFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testInform() throws Exception {
        ClasspathResourceLoader loader = new ClasspathResourceLoader(((Object)((Object)this)).getClass());
        TestKeepFilterFactory.assertTrue((String)"loader is null and it shouldn't be", (loader != null ? 1 : 0) != 0);
        KeepWordFilterFactory factory = (KeepWordFilterFactory)this.tokenFilterFactory("KeepWord", "words", "keep-1.txt", "ignoreCase", "true");
        CharArraySet words = factory.getWords();
        TestKeepFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestKeepFilterFactory.assertTrue((String)("words Size: " + words.size() + " is not: " + 2), (words.size() == 2 ? 1 : 0) != 0);
        factory = (KeepWordFilterFactory)this.tokenFilterFactory("KeepWord", "words", "keep-1.txt, keep-2.txt", "ignoreCase", "true");
        words = factory.getWords();
        TestKeepFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestKeepFilterFactory.assertTrue((String)("words Size: " + words.size() + " is not: " + 4), (words.size() == 4 ? 1 : 0) != 0);
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestKeepFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("KeepWord", "bogusArg", "bogusValue"));
        TestKeepFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

