/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.miscellaneous.KeepWordFilter;

public class TestKeepWordFilter
extends BaseTokenStreamTestCase {
    public void testStopAndGo() throws Exception {
        HashSet<String> words = new HashSet<String>();
        words.add("aaa");
        words.add("bbb");
        String input = "xxx yyy aaa zzz BBB ccc ddd EEE";
        MockTokenizer stream = TestKeepWordFilter.whitespaceMockTokenizer((String)input);
        stream = new KeepWordFilter((TokenStream)stream, new CharArraySet(words, true));
        TestKeepWordFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"aaa", "BBB"}, (int[])new int[]{3, 2});
        stream = TestKeepWordFilter.whitespaceMockTokenizer((String)input);
        stream = new KeepWordFilter((TokenStream)stream, new CharArraySet(words, false));
        TestKeepWordFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"aaa"}, (int[])new int[]{3});
    }

    public void testRandomStrings() throws Exception {
        final HashSet<String> words = new HashSet<String>();
        words.add("a");
        words.add("b");
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                KeepWordFilter stream = new KeepWordFilter((TokenStream)tokenizer, new CharArraySet((Collection)words, true));
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
        TestKeepWordFilter.checkRandomData((Random)TestKeepWordFilter.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

