/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.PatternKeywordMarkerFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.junit.Test;

public class TestKeywordMarkerFilter
extends BaseTokenStreamTestCase {
    @Test
    public void testSetFilterIncrementToken() throws IOException {
        CharArraySet set = new CharArraySet(5, true);
        set.add("lucenefox");
        String[] output = new String[]{"the", "quick", "brown", "LuceneFox", "jumps"};
        TestKeywordMarkerFilter.assertTokenStreamContents((TokenStream)new LowerCaseFilterMock((TokenStream)new SetKeywordMarkerFilter((TokenStream)TestKeywordMarkerFilter.whitespaceMockTokenizer((String)"The quIck browN LuceneFox Jumps"), set)), (String[])output);
        CharArraySet mixedCaseSet = new CharArraySet((Collection)TestKeywordMarkerFilter.asSet((Object[])new String[]{"LuceneFox"}), false);
        TestKeywordMarkerFilter.assertTokenStreamContents((TokenStream)new LowerCaseFilterMock((TokenStream)new SetKeywordMarkerFilter((TokenStream)TestKeywordMarkerFilter.whitespaceMockTokenizer((String)"The quIck browN LuceneFox Jumps"), mixedCaseSet)), (String[])output);
        CharArraySet set2 = set;
        TestKeywordMarkerFilter.assertTokenStreamContents((TokenStream)new LowerCaseFilterMock((TokenStream)new SetKeywordMarkerFilter((TokenStream)TestKeywordMarkerFilter.whitespaceMockTokenizer((String)"The quIck browN LuceneFox Jumps"), set2)), (String[])output);
    }

    @Test
    public void testPatternFilterIncrementToken() throws IOException {
        String[] output = new String[]{"the", "quick", "brown", "LuceneFox", "jumps"};
        TestKeywordMarkerFilter.assertTokenStreamContents((TokenStream)new LowerCaseFilterMock((TokenStream)new PatternKeywordMarkerFilter((TokenStream)TestKeywordMarkerFilter.whitespaceMockTokenizer((String)"The quIck browN LuceneFox Jumps"), Pattern.compile("[a-zA-Z]+[fF]ox"))), (String[])output);
        output = new String[]{"the", "quick", "brown", "lucenefox", "jumps"};
        TestKeywordMarkerFilter.assertTokenStreamContents((TokenStream)new LowerCaseFilterMock((TokenStream)new PatternKeywordMarkerFilter((TokenStream)TestKeywordMarkerFilter.whitespaceMockTokenizer((String)"The quIck browN LuceneFox Jumps"), Pattern.compile("[a-zA-Z]+[f]ox"))), (String[])output);
    }

    public void testComposition() throws Exception {
        LowerCaseFilterMock ts = new LowerCaseFilterMock((TokenStream)new SetKeywordMarkerFilter((TokenStream)new SetKeywordMarkerFilter((TokenStream)TestKeywordMarkerFilter.whitespaceMockTokenizer((String)"Dogs Trees Birds Houses"), new CharArraySet((Collection)TestKeywordMarkerFilter.asSet((Object[])new String[]{"Birds", "Houses"}), false)), new CharArraySet((Collection)TestKeywordMarkerFilter.asSet((Object[])new String[]{"Dogs", "Trees"}), false)));
        TestKeywordMarkerFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"Dogs", "Trees", "Birds", "Houses"});
        ts = new LowerCaseFilterMock((TokenStream)new PatternKeywordMarkerFilter((TokenStream)new PatternKeywordMarkerFilter((TokenStream)TestKeywordMarkerFilter.whitespaceMockTokenizer((String)"Dogs Trees Birds Houses"), Pattern.compile("Birds|Houses")), Pattern.compile("Dogs|Trees")));
        TestKeywordMarkerFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"Dogs", "Trees", "Birds", "Houses"});
        ts = new LowerCaseFilterMock((TokenStream)new SetKeywordMarkerFilter((TokenStream)new PatternKeywordMarkerFilter((TokenStream)TestKeywordMarkerFilter.whitespaceMockTokenizer((String)"Dogs Trees Birds Houses"), Pattern.compile("Birds|Houses")), new CharArraySet((Collection)TestKeywordMarkerFilter.asSet((Object[])new String[]{"Dogs", "Trees"}), false)));
        TestKeywordMarkerFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"Dogs", "Trees", "Birds", "Houses"});
    }

    public static final class LowerCaseFilterMock
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final KeywordAttribute keywordAttr = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);

        public LowerCaseFilterMock(TokenStream in) {
            super(in);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                if (!this.keywordAttr.isKeyword()) {
                    String term = this.termAtt.toString().toLowerCase(Locale.ROOT);
                    this.termAtt.setEmpty().append(term);
                }
                return true;
            }
            return false;
        }
    }
}

