/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.StringMockResourceLoader;
import org.apache.lucene.util.Version;

public class TestKeywordMarkerFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testKeywords() throws Exception {
        StringReader reader = new StringReader("dogs cats");
        MockTokenizer stream = TestKeywordMarkerFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("KeywordMarker", Version.LATEST, new StringMockResourceLoader("cats"), "protected", "protwords.txt").create((TokenStream)stream);
        stream = this.tokenFilterFactory("PorterStem", new String[0]).create((TokenStream)stream);
        TestKeywordMarkerFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"dog", "cats"});
    }

    public void testKeywords2() throws Exception {
        StringReader reader = new StringReader("dogs cats");
        MockTokenizer stream = TestKeywordMarkerFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("KeywordMarker", "pattern", "cats|Dogs").create((TokenStream)stream);
        stream = this.tokenFilterFactory("PorterStem", new String[0]).create((TokenStream)stream);
        TestKeywordMarkerFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"dog", "cats"});
    }

    public void testKeywordsMixed() throws Exception {
        StringReader reader = new StringReader("dogs cats birds");
        MockTokenizer stream = TestKeywordMarkerFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("KeywordMarker", Version.LATEST, new StringMockResourceLoader("cats"), "protected", "protwords.txt", "pattern", "birds|Dogs").create((TokenStream)stream);
        stream = this.tokenFilterFactory("PorterStem", new String[0]).create((TokenStream)stream);
        TestKeywordMarkerFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"dog", "cats", "birds"});
    }

    public void testKeywordsCaseInsensitive() throws Exception {
        StringReader reader = new StringReader("dogs cats Cats");
        MockTokenizer stream = TestKeywordMarkerFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("KeywordMarker", Version.LATEST, new StringMockResourceLoader("cats"), "protected", "protwords.txt", "ignoreCase", "true").create((TokenStream)stream);
        stream = this.tokenFilterFactory("PorterStem", new String[0]).create((TokenStream)stream);
        TestKeywordMarkerFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"dog", "cats", "Cats"});
    }

    public void testKeywordsCaseInsensitive2() throws Exception {
        StringReader reader = new StringReader("dogs cats Cats");
        MockTokenizer stream = TestKeywordMarkerFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("KeywordMarker", "pattern", "Cats", "ignoreCase", "true").create((TokenStream)stream);
        stream = this.tokenFilterFactory("PorterStem", new String[0]).create((TokenStream)stream);
        TestKeywordMarkerFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"dog", "cats", "Cats"});
    }

    public void testKeywordsCaseInsensitiveMixed() throws Exception {
        StringReader reader = new StringReader("dogs cats Cats Birds birds");
        MockTokenizer stream = TestKeywordMarkerFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("KeywordMarker", Version.LATEST, new StringMockResourceLoader("cats"), "protected", "protwords.txt", "pattern", "birds", "ignoreCase", "true").create((TokenStream)stream);
        stream = this.tokenFilterFactory("PorterStem", new String[0]).create((TokenStream)stream);
        TestKeywordMarkerFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"dog", "cats", "Cats", "Birds", "birds"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestKeywordMarkerFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("KeywordMarker", "bogusArg", "bogusValue"));
        TestKeywordMarkerFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

