/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.junit.Test;

public class TestLengthFilter
extends BaseTokenStreamTestCase {
    public void testFilterWithPosIncr() throws Exception {
        MockTokenizer stream = TestLengthFilter.whitespaceMockTokenizer((String)"short toolong evenmuchlongertext a ab toolong foo");
        LengthFilter filter = new LengthFilter((TokenStream)stream, 2, 6);
        TestLengthFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"short", "ab", "foo"}, (int[])new int[]{1, 4, 2});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LengthFilter((TokenStream)tokenizer, 0, 5));
            }
        };
        TestLengthFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArguments() throws Exception {
        new LengthFilter((TokenStream)TestLengthFilter.whitespaceMockTokenizer((String)"accept only valid arguments"), -4, -1);
    }
}

