/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.TestUtil;

public class TestLimitTokenCountAnalyzer
extends BaseTokenStreamTestCase {
    public void testLimitTokenCountAnalyzer() throws IOException {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockAnalyzer mock = new MockAnalyzer(TestLimitTokenCountAnalyzer.random());
            mock.setEnableChecks(consumeAll);
            LimitTokenCountAnalyzer a = new LimitTokenCountAnalyzer((Analyzer)mock, 2, consumeAll);
            TestLimitTokenCountAnalyzer.assertTokenStreamContents((TokenStream)a.tokenStream("dummy", "1  2     3  4  5"), (String[])new String[]{"1", "2"}, (int[])new int[]{0, 3}, (int[])new int[]{1, 4}, (Integer)(consumeAll ? Integer.valueOf(16) : null));
            TestLimitTokenCountAnalyzer.assertTokenStreamContents((TokenStream)a.tokenStream("dummy", "1 2 3 4 5"), (String[])new String[]{"1", "2"}, (int[])new int[]{0, 2}, (int[])new int[]{1, 3}, (Integer)(consumeAll ? Integer.valueOf(9) : null));
            TestLimitTokenCountAnalyzer.assertTokenStreamContents((TokenStream)a.tokenStream("dummy", "1  "), (String[])new String[]{"1"}, (int[])new int[]{0}, (int[])new int[]{1}, (Integer)(consumeAll ? Integer.valueOf(3) : null));
            TestLimitTokenCountAnalyzer.assertTokenStreamContents((TokenStream)a.tokenStream("dummy", "1  2  "), (String[])new String[]{"1", "2"}, (int[])new int[]{0, 3}, (int[])new int[]{1, 4}, (Integer)(consumeAll ? Integer.valueOf(6) : null));
            a.close();
        }
    }

    public void testLimitTokenCountIndexWriter() throws IOException {
        for (boolean consumeAll : new boolean[]{true, false}) {
            BaseDirectoryWrapper dir = TestLimitTokenCountAnalyzer.newDirectory();
            int limit = TestUtil.nextInt((Random)TestLimitTokenCountAnalyzer.random(), (int)50, (int)101000);
            MockAnalyzer mock = new MockAnalyzer(TestLimitTokenCountAnalyzer.random());
            mock.setEnableChecks(consumeAll);
            LimitTokenCountAnalyzer a = new LimitTokenCountAnalyzer((Analyzer)mock, limit, consumeAll);
            IndexWriter writer = new IndexWriter((Directory)dir, new IndexWriterConfig((Analyzer)a));
            Document doc = new Document();
            StringBuilder b = new StringBuilder();
            for (int i = 1; i < limit; ++i) {
                b.append(" a");
            }
            b.append(" x");
            b.append(" z");
            doc.add((IndexableField)TestLimitTokenCountAnalyzer.newTextField((String)"field", (String)b.toString(), (Field.Store)Field.Store.NO));
            writer.addDocument((Iterable)doc);
            writer.close();
            DirectoryReader reader = DirectoryReader.open((Directory)dir);
            Term t = new Term("field", "x");
            TestLimitTokenCountAnalyzer.assertEquals((long)1L, (long)reader.docFreq(t));
            t = new Term("field", "z");
            TestLimitTokenCountAnalyzer.assertEquals((long)0L, (long)reader.docFreq(t));
            reader.close();
            dir.close();
            a.close();
        }
    }
}

