/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.junit.Test;

public class TestLimitTokenCountFilter
extends BaseTokenStreamTestCase {
    public void test() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockTokenizer tokenizer = TestLimitTokenCountFilter.whitespaceMockTokenizer((String)"A1 B2 C3 D4 E5 F6");
            tokenizer.setEnableChecks(consumeAll);
            LimitTokenCountFilter stream = new LimitTokenCountFilter((TokenStream)tokenizer, 3, consumeAll);
            TestLimitTokenCountFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"A1", "B2", "C3"});
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArguments() throws Exception {
        new LimitTokenCountFilter((TokenStream)TestLimitTokenCountFilter.whitespaceMockTokenizer((String)"A1 B2 C3 D4 E5 F6"), -1);
    }
}

