/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;
import org.junit.Test;

public class TestLimitTokenOffsetFilter
extends BaseTokenStreamTestCase {
    public void test() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockTokenizer tokenizer = TestLimitTokenOffsetFilter.whitespaceMockTokenizer((String)"A1 B2 C3 D4 E5 F6");
            tokenizer.setEnableChecks(consumeAll);
            LimitTokenOffsetFilter stream = new LimitTokenOffsetFilter((TokenStream)tokenizer, 3, consumeAll);
            TestLimitTokenOffsetFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"A1", "B2"});
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArguments() throws Exception {
        new LimitTokenOffsetFilter((TokenStream)TestLimitTokenOffsetFilter.whitespaceMockTokenizer((String)"A1 B2 C3 D4 E5 F6"), -1);
    }
}

