/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestLimitTokenOffsetFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void test() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            StringReader reader = new StringReader("A1 B2 C3 D4 E5 F6");
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
            tokenizer.setReader((Reader)reader);
            tokenizer.setEnableChecks(consumeAll);
            MockTokenizer stream = tokenizer;
            stream = this.tokenFilterFactory("LimitTokenOffset", "maxStartOffset", "3", "consumeAllTokens", Boolean.toString(consumeAll)).create((TokenStream)stream);
            TestLimitTokenOffsetFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"A1", "B2"});
        }
    }

    public void testRequired() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestLimitTokenOffsetFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("LimitTokenOffset", new String[0]));
        TestLimitTokenOffsetFilterFactory.assertTrue((String)("exception doesn't mention param: " + expected.getMessage()), (0 < expected.getMessage().indexOf("maxStartOffset") ? 1 : 0) != 0);
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestLimitTokenOffsetFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("LimitTokenOffset", "maxStartOffset", "3", "bogusArg", "bogusValue"));
        TestLimitTokenOffsetFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

