/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenPositionFilter;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.junit.Test;

public class TestLimitTokenPositionFilter
extends BaseTokenStreamTestCase {
    public void testMaxPosition2() throws IOException {
        for (final boolean consumeAll : new boolean[]{true, false}) {
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    tokenizer.setEnableChecks(consumeAll);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LimitTokenPositionFilter((TokenStream)tokenizer, 2, consumeAll));
                }
            };
            TestLimitTokenPositionFilter.assertTokenStreamContents((TokenStream)a.tokenStream("dummy", "1  2     3  4  5"), (String[])new String[]{"1", "2"}, (int[])new int[]{0, 3}, (int[])new int[]{1, 4}, (Integer)(consumeAll ? Integer.valueOf(16) : null));
            TestLimitTokenPositionFilter.assertTokenStreamContents((TokenStream)a.tokenStream("dummy", (Reader)new StringReader("1 2 3 4 5")), (String[])new String[]{"1", "2"}, (int[])new int[]{0, 2}, (int[])new int[]{1, 3}, (Integer)(consumeAll ? Integer.valueOf(9) : null));
            TestLimitTokenPositionFilter.assertTokenStreamContents((TokenStream)a.tokenStream("dummy", "1  "), (String[])new String[]{"1"}, (int[])new int[]{0}, (int[])new int[]{1}, (Integer)(consumeAll ? Integer.valueOf(3) : null));
            TestLimitTokenPositionFilter.assertTokenStreamContents((TokenStream)a.tokenStream("dummy", "1  2  "), (String[])new String[]{"1", "2"}, (int[])new int[]{0, 3}, (int[])new int[]{1, 4}, (Integer)(consumeAll ? Integer.valueOf(6) : null));
            a.close();
        }
    }

    public void testMaxPosition3WithSynomyms() throws IOException {
        for (boolean consumeAll : new boolean[]{true, false}) {
            MockTokenizer tokenizer = TestLimitTokenPositionFilter.whitespaceMockTokenizer((String)"one two three four five");
            tokenizer.setEnableChecks(consumeAll);
            SynonymMap.Builder builder = new SynonymMap.Builder(true);
            builder.add(new CharsRef("one"), new CharsRef("first"), true);
            builder.add(new CharsRef("one"), new CharsRef("alpha"), true);
            builder.add(new CharsRef("one"), new CharsRef("beguine"), true);
            CharsRefBuilder multiWordCharsRef = new CharsRefBuilder();
            SynonymMap.Builder.join((String[])new String[]{"and", "indubitably", "single", "only"}, (CharsRefBuilder)multiWordCharsRef);
            builder.add(new CharsRef("one"), multiWordCharsRef.get(), true);
            SynonymMap.Builder.join((String[])new String[]{"dopple", "ganger"}, (CharsRefBuilder)multiWordCharsRef);
            builder.add(new CharsRef("two"), multiWordCharsRef.get(), true);
            SynonymMap synonymMap = builder.build();
            SynonymFilter stream = new SynonymFilter((TokenStream)tokenizer, synonymMap, true);
            stream = new LimitTokenPositionFilter((TokenStream)stream, 3, consumeAll);
            TestLimitTokenPositionFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"one", "first", "alpha", "beguine", "and", "two", "indubitably", "dopple", "three", "single", "ganger"}, (int[])new int[]{1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0});
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArguments() throws Exception {
        new LimitTokenPositionFilter((TokenStream)TestLimitTokenPositionFilter.whitespaceMockTokenizer((String)"one two three four five"), 0);
    }
}

