/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestLimitTokenPositionFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testMaxPosition1() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            StringReader reader = new StringReader("A1 B2 C3 D4 E5 F6");
            MockTokenizer tokenizer = TestLimitTokenPositionFilterFactory.whitespaceMockTokenizer((Reader)reader);
            tokenizer.setEnableChecks(consumeAll);
            MockTokenizer stream = tokenizer;
            stream = this.tokenFilterFactory("LimitTokenPosition", "maxTokenPosition", "1", "consumeAllTokens", Boolean.toString(consumeAll)).create((TokenStream)stream);
            TestLimitTokenPositionFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"A1"});
        }
    }

    public void testMissingParam() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestLimitTokenPositionFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("LimitTokenPosition", new String[0]));
        TestLimitTokenPositionFilterFactory.assertTrue((String)("exception doesn't mention param: " + expected.getMessage()), (0 < expected.getMessage().indexOf("maxTokenPosition") ? 1 : 0) != 0);
    }

    public void testMaxPosition1WithShingles() throws Exception {
        for (boolean consumeAll : new boolean[]{true, false}) {
            StringReader reader = new StringReader("one two three four five");
            MockTokenizer tokenizer = TestLimitTokenPositionFilterFactory.whitespaceMockTokenizer((Reader)reader);
            tokenizer.setEnableChecks(consumeAll);
            MockTokenizer stream = tokenizer;
            stream = this.tokenFilterFactory("Shingle", "minShingleSize", "2", "maxShingleSize", "3", "outputUnigrams", "true").create((TokenStream)stream);
            stream = this.tokenFilterFactory("LimitTokenPosition", "maxTokenPosition", "1", "consumeAllTokens", Boolean.toString(consumeAll)).create((TokenStream)stream);
            TestLimitTokenPositionFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"one", "one two", "one two three"});
        }
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestLimitTokenPositionFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("LimitTokenPosition", "maxTokenPosition", "3", "bogusArg", "bogusValue"));
        TestLimitTokenPositionFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

