/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Closeable;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockCharFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.IOUtils;
import org.junit.Assert;

public class TestPerFieldAnalyzerWrapper
extends BaseTokenStreamTestCase {
    public void testPerField() throws Exception {
        CharTermAttribute termAtt;
        String text = "Qwerty";
        Map<String, SimpleAnalyzer> analyzerPerField = Collections.singletonMap("special", new SimpleAnalyzer());
        WhitespaceAnalyzer defaultAnalyzer = new WhitespaceAnalyzer();
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)defaultAnalyzer, analyzerPerField);
        try (TokenStream tokenStream = analyzer.tokenStream("field", text);){
            termAtt = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            tokenStream.reset();
            TestPerFieldAnalyzerWrapper.assertTrue((boolean)tokenStream.incrementToken());
            TestPerFieldAnalyzerWrapper.assertEquals((String)"WhitespaceAnalyzer does not lowercase", (Object)"Qwerty", (Object)termAtt.toString());
            TestPerFieldAnalyzerWrapper.assertFalse((boolean)tokenStream.incrementToken());
            tokenStream.end();
        }
        tokenStream = analyzer.tokenStream("special", text);
        try {
            termAtt = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            tokenStream.reset();
            TestPerFieldAnalyzerWrapper.assertTrue((boolean)tokenStream.incrementToken());
            TestPerFieldAnalyzerWrapper.assertEquals((String)"SimpleAnalyzer lowercases", (Object)"qwerty", (Object)termAtt.toString());
            TestPerFieldAnalyzerWrapper.assertFalse((boolean)tokenStream.incrementToken());
            tokenStream.end();
        }
        finally {
            if (tokenStream != null) {
                tokenStream.close();
            }
        }
        analyzer.close();
        defaultAnalyzer.close();
        IOUtils.close(analyzerPerField.values());
    }

    public void testReuseWrapped() throws Exception {
        String text = "Qwerty";
        SimpleAnalyzer specialAnalyzer = new SimpleAnalyzer();
        WhitespaceAnalyzer defaultAnalyzer = new WhitespaceAnalyzer();
        final PerFieldAnalyzerWrapper wrapper1 = new PerFieldAnalyzerWrapper((Analyzer)defaultAnalyzer, Collections.singletonMap("special", specialAnalyzer));
        TokenStream ts1 = defaultAnalyzer.tokenStream("something", "Qwerty");
        TokenStream ts2 = wrapper1.tokenStream("something", "Qwerty");
        TestPerFieldAnalyzerWrapper.assertSame((Object)ts1, (Object)ts2);
        ts1 = specialAnalyzer.tokenStream("special", "Qwerty");
        ts2 = wrapper1.tokenStream("special", "Qwerty");
        TestPerFieldAnalyzerWrapper.assertSame((Object)ts1, (Object)ts2);
        AnalyzerWrapper wrapper2 = new AnalyzerWrapper(wrapper1.getReuseStrategy(), (Analyzer)specialAnalyzer){
            final /* synthetic */ Analyzer val$specialAnalyzer;
            {
                this.val$specialAnalyzer = analyzer;
                super(arg0);
            }

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return wrapper1;
            }

            protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
                Assert.assertNotSame((Object)this.val$specialAnalyzer.tokenStream("special", "Qwerty"), (Object)components.getTokenStream());
                ASCIIFoldingFilter filter = new ASCIIFoldingFilter(components.getTokenStream());
                return new Analyzer.TokenStreamComponents(components.getTokenizer(), (TokenStream)filter);
            }
        };
        TokenStream ts3 = wrapper2.tokenStream("special", "Qwerty");
        TestPerFieldAnalyzerWrapper.assertNotSame((Object)ts1, (Object)ts3);
        TestPerFieldAnalyzerWrapper.assertTrue((boolean)(ts3 instanceof ASCIIFoldingFilter));
        ts2 = wrapper1.tokenStream("special", "Qwerty");
        TestPerFieldAnalyzerWrapper.assertSame((Object)ts1, (Object)ts2);
        PerFieldAnalyzerWrapper wrapper3 = new PerFieldAnalyzerWrapper((Analyzer)wrapper1, Collections.singletonMap("moreSpecial", specialAnalyzer));
        ts1 = specialAnalyzer.tokenStream("special", "Qwerty");
        ts2 = wrapper3.tokenStream("special", "Qwerty");
        TestPerFieldAnalyzerWrapper.assertSame((Object)ts1, (Object)ts2);
        ts3 = specialAnalyzer.tokenStream("moreSpecial", "Qwerty");
        TokenStream ts4 = wrapper3.tokenStream("moreSpecial", "Qwerty");
        TestPerFieldAnalyzerWrapper.assertSame((Object)ts3, (Object)ts4);
        TestPerFieldAnalyzerWrapper.assertSame((Object)ts2, (Object)ts3);
        IOUtils.close((Closeable[])new Closeable[]{wrapper3, wrapper2, wrapper1, specialAnalyzer, defaultAnalyzer});
    }

    public void testCharFilters() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }

            protected Reader initReader(String fieldName, Reader reader) {
                return new MockCharFilter(reader, 7);
            }
        };
        TestPerFieldAnalyzerWrapper.assertAnalyzesTo((Analyzer)a, (String)"ab", (String[])new String[]{"aab"}, (int[])new int[]{0}, (int[])new int[]{2});
        PerFieldAnalyzerWrapper p = new PerFieldAnalyzerWrapper(a, Collections.emptyMap());
        TestPerFieldAnalyzerWrapper.assertAnalyzesTo((Analyzer)p, (String)"ab", (String[])new String[]{"aab"}, (int[])new int[]{0}, (int[])new int[]{2});
        p.close();
        a.close();
    }
}

