/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.PrefixAndSuffixAwareTokenFilter;

public class TestPrefixAndSuffixAwareTokenFilter
extends BaseTokenStreamTestCase {
    public void test() throws IOException {
        MockTokenizer input = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        input.setReader((Reader)new StringReader("hello world"));
        PrefixAndSuffixAwareTokenFilter ts = new PrefixAndSuffixAwareTokenFilter((TokenStream)new CannedTokenStream(new Token[]{TestPrefixAndSuffixAwareTokenFilter.createToken("^", 0, 0)}), (TokenStream)input, (TokenStream)new CannedTokenStream(new Token[]{TestPrefixAndSuffixAwareTokenFilter.createToken("$", 0, 0)}));
        TestPrefixAndSuffixAwareTokenFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"^", "hello", "world", "$"}, (int[])new int[]{0, 0, 6, 11}, (int[])new int[]{0, 5, 11, 11});
    }

    private static Token createToken(String term, int start, int offset) {
        return new Token((CharSequence)term, start, offset);
    }
}

