/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.PrefixAwareTokenFilter;

public class TestPrefixAwareTokenFilter
extends BaseTokenStreamTestCase {
    public void test() throws IOException {
        PrefixAwareTokenFilter ts = new PrefixAwareTokenFilter((TokenStream)new CannedTokenStream(new Token[]{TestPrefixAwareTokenFilter.createToken("a", 0, 1)}), (TokenStream)new CannedTokenStream(new Token[]{TestPrefixAwareTokenFilter.createToken("b", 0, 1)}));
        TestPrefixAwareTokenFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"a", "b"}, (int[])new int[]{0, 1}, (int[])new int[]{1, 2});
        MockTokenizer suffix = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        suffix.setReader((Reader)new StringReader("hello world"));
        ts = new PrefixAwareTokenFilter((TokenStream)new CannedTokenStream(new Token[]{TestPrefixAwareTokenFilter.createToken("^", 0, 0)}), (TokenStream)suffix);
        ts = new PrefixAwareTokenFilter((TokenStream)ts, (TokenStream)new CannedTokenStream(new Token[]{TestPrefixAwareTokenFilter.createToken("$", 0, 0)}));
        TestPrefixAwareTokenFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"^", "hello", "world", "$"}, (int[])new int[]{0, 0, 6, 11}, (int[])new int[]{0, 5, 11, 11});
    }

    private static Token createToken(String term, int start, int offset) {
        return new Token((CharSequence)term, start, offset);
    }
}

