/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.RemoveDuplicatesTokenFilter;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.TestUtil;

public class TestRemoveDuplicatesTokenFilter
extends BaseTokenStreamTestCase {
    public static Token tok(int pos, String t, int start, int end) {
        Token tok = new Token((CharSequence)t, start, end);
        tok.setPositionIncrement(pos);
        return tok;
    }

    public static Token tok(int pos, String t) {
        return TestRemoveDuplicatesTokenFilter.tok(pos, t, 0, 0);
    }

    public void testDups(String expected, Token ... tokens) throws Exception {
        final Iterator<Token> toks = Arrays.asList(tokens).iterator();
        RemoveDuplicatesTokenFilter ts = new RemoveDuplicatesTokenFilter(new TokenStream(){
            CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

            public boolean incrementToken() {
                if (toks.hasNext()) {
                    this.clearAttributes();
                    Token tok = (Token)toks.next();
                    this.termAtt.setEmpty().append((CharTermAttribute)tok);
                    this.offsetAtt.setOffset(tok.startOffset(), tok.endOffset());
                    this.posIncAtt.setPositionIncrement(tok.getPositionIncrement());
                    return true;
                }
                return false;
            }
        });
        TestRemoveDuplicatesTokenFilter.assertTokenStreamContents((TokenStream)ts, (String[])expected.split("\\s"));
    }

    public void testNoDups() throws Exception {
        this.testDups("A B B C D E", TestRemoveDuplicatesTokenFilter.tok(1, "A", 0, 4), TestRemoveDuplicatesTokenFilter.tok(1, "B", 5, 10), TestRemoveDuplicatesTokenFilter.tok(1, "B", 11, 15), TestRemoveDuplicatesTokenFilter.tok(1, "C", 16, 20), TestRemoveDuplicatesTokenFilter.tok(0, "D", 16, 20), TestRemoveDuplicatesTokenFilter.tok(1, "E", 21, 25));
    }

    public void testSimpleDups() throws Exception {
        this.testDups("A B C D E", TestRemoveDuplicatesTokenFilter.tok(1, "A", 0, 4), TestRemoveDuplicatesTokenFilter.tok(1, "B", 5, 10), TestRemoveDuplicatesTokenFilter.tok(0, "B", 11, 15), TestRemoveDuplicatesTokenFilter.tok(1, "C", 16, 20), TestRemoveDuplicatesTokenFilter.tok(0, "D", 16, 20), TestRemoveDuplicatesTokenFilter.tok(1, "E", 21, 25));
    }

    public void testComplexDups() throws Exception {
        this.testDups("A B C D E F G H I J K", TestRemoveDuplicatesTokenFilter.tok(1, "A"), TestRemoveDuplicatesTokenFilter.tok(1, "B"), TestRemoveDuplicatesTokenFilter.tok(0, "B"), TestRemoveDuplicatesTokenFilter.tok(1, "C"), TestRemoveDuplicatesTokenFilter.tok(1, "D"), TestRemoveDuplicatesTokenFilter.tok(0, "D"), TestRemoveDuplicatesTokenFilter.tok(0, "D"), TestRemoveDuplicatesTokenFilter.tok(1, "E"), TestRemoveDuplicatesTokenFilter.tok(1, "F"), TestRemoveDuplicatesTokenFilter.tok(0, "F"), TestRemoveDuplicatesTokenFilter.tok(1, "G"), TestRemoveDuplicatesTokenFilter.tok(0, "H"), TestRemoveDuplicatesTokenFilter.tok(0, "H"), TestRemoveDuplicatesTokenFilter.tok(1, "I"), TestRemoveDuplicatesTokenFilter.tok(1, "J"), TestRemoveDuplicatesTokenFilter.tok(0, "K"), TestRemoveDuplicatesTokenFilter.tok(0, "J"));
    }

    private String randomNonEmptyString() {
        String s;
        while ((s = TestUtil.randomUnicodeString((Random)TestRemoveDuplicatesTokenFilter.random()).trim()).length() == 0 || s.indexOf(0) != -1) {
        }
        return s;
    }

    private void add(SynonymMap.Builder b, String input, String output, boolean keepOrig) {
        b.add(new CharsRef(input.replaceAll(" +", "\u0000")), new CharsRef(output.replaceAll(" +", "\u0000")), keepOrig);
    }

    public void testRandomStrings() throws Exception {
        int numIters = TestRemoveDuplicatesTokenFilter.atLeast((int)10);
        for (int i = 0; i < numIters; ++i) {
            SynonymMap.Builder b = new SynonymMap.Builder(TestRemoveDuplicatesTokenFilter.random().nextBoolean());
            int numEntries = TestRemoveDuplicatesTokenFilter.atLeast((int)10);
            for (int j = 0; j < numEntries; ++j) {
                this.add(b, this.randomNonEmptyString(), this.randomNonEmptyString(), TestRemoveDuplicatesTokenFilter.random().nextBoolean());
            }
            final SynonymMap map = b.build();
            final boolean ignoreCase = TestRemoveDuplicatesTokenFilter.random().nextBoolean();
            Analyzer analyzer = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
                    SynonymFilter stream = new SynonymFilter((TokenStream)tokenizer, map, ignoreCase);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new RemoveDuplicatesTokenFilter((TokenStream)stream));
                }
            };
            TestRemoveDuplicatesTokenFilter.checkRandomData((Random)TestRemoveDuplicatesTokenFilter.random(), (Analyzer)analyzer, (int)200);
            analyzer.close();
        }
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new RemoveDuplicatesTokenFilter((TokenStream)tokenizer));
            }
        };
        TestRemoveDuplicatesTokenFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

