/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestRemoveDuplicatesTokenFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public static Token tok(int pos, String t, int start, int end) {
        Token tok = new Token((CharSequence)t, start, end);
        tok.setPositionIncrement(pos);
        return tok;
    }

    public void testDups(String expected, Token ... tokens) throws Exception {
        CannedTokenStream stream = new CannedTokenStream(tokens);
        stream = this.tokenFilterFactory("RemoveDuplicates", new String[0]).create((TokenStream)stream);
        TestRemoveDuplicatesTokenFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])expected.split("\\s"));
    }

    public void testSimpleDups() throws Exception {
        this.testDups("A B C D E", TestRemoveDuplicatesTokenFilterFactory.tok(1, "A", 0, 4), TestRemoveDuplicatesTokenFilterFactory.tok(1, "B", 5, 10), TestRemoveDuplicatesTokenFilterFactory.tok(0, "B", 11, 15), TestRemoveDuplicatesTokenFilterFactory.tok(1, "C", 16, 20), TestRemoveDuplicatesTokenFilterFactory.tok(0, "D", 16, 20), TestRemoveDuplicatesTokenFilterFactory.tok(1, "E", 21, 25));
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestRemoveDuplicatesTokenFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("RemoveDuplicates", "bogusArg", "bogusValue"));
        TestRemoveDuplicatesTokenFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

