/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.ScandinavianFoldingFilter;

public class TestScandinavianFoldingFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                ScandinavianFoldingFilter stream = new ScandinavianFoldingFilter((TokenStream)tokenizer);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void test() throws Exception {
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ae\u00e4aeeea", (String)"aaaeea");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ae\u00e4aeeeae", (String)"aaaeea");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aeaeeeae", (String)"aaeea");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"b\u00f8en", (String)"boen");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e5ene", (String)"aene");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bl\u00e5b\u00e6rsyltet\u00f8j", (String)"blabarsyltetoj");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"blaabaarsyltetoej", (String)"blabarsyltetoj");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bl\u00e5b\u00e4rsyltet\u00f6j", (String)"blabarsyltetoj");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"raksmorgas", (String)"raksmorgas");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"r\u00e4ksm\u00f6rg\u00e5s", (String)"raksmorgas");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"r\u00e6ksm\u00f8rg\u00e5s", (String)"raksmorgas");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"raeksmoergaas", (String)"raksmorgas");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"r\u00e6ksm\u00f6rgaos", (String)"raksmorgas");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ab", (String)"ab");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ob", (String)"ob");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Ab", (String)"Ab");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Ob", (String)"Ob");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e5", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aa", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aA", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ao", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aO", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"AA", (String)"A");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Aa", (String)"A");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Ao", (String)"A");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"AO", (String)"A");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e6", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e4", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00c6", (String)"A");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00c4", (String)"A");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ae", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aE", (String)"a");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Ae", (String)"A");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"AE", (String)"A");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00f6", (String)"o");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00f8", (String)"o");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00d6", (String)"O");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00d8", (String)"O");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"oo", (String)"o");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"oe", (String)"o");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"oO", (String)"o");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"oE", (String)"o");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Oo", (String)"O");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Oe", (String)"O");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"OO", (String)"O");
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)this.analyzer, (String)"OE", (String)"O");
    }

    public void testEmptyTerm() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ScandinavianFoldingFilter((TokenStream)tokenizer));
            }
        };
        TestScandinavianFoldingFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    public void testRandomData() throws Exception {
        TestScandinavianFoldingFilter.checkRandomData((Random)TestScandinavianFoldingFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }
}

