/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestScandinavianFoldingFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("r\u00e4ksm\u00f6rg\u00e5s");
        MockTokenizer stream = TestScandinavianFoldingFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("ScandinavianFolding", new String[0]).create((TokenStream)stream);
        TestScandinavianFoldingFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"raksmorgas"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestScandinavianFoldingFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("ScandinavianFolding", "bogusArg", "bogusValue"));
        TestScandinavianFoldingFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

