/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.ScandinavianNormalizationFilter;

public class TestScandinavianNormalizationFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                ScandinavianNormalizationFilter stream = new ScandinavianNormalizationFilter((TokenStream)tokenizer);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void test() throws Exception {
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ae\u00e4aeeea", (String)"\u00e6\u00e6\u00e6eea");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ae\u00e4aeeeae", (String)"\u00e6\u00e6\u00e6ee\u00e6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aeaeeeae", (String)"\u00e6\u00e6ee\u00e6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"b\u00f8en", (String)"b\u00f8en");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bOEen", (String)"b\u00d8en");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e5ene", (String)"\u00e5ene");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bl\u00e5b\u00e6rsyltet\u00f8j", (String)"bl\u00e5b\u00e6rsyltet\u00f8j");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"blaabaersyltet\u00f6j", (String)"bl\u00e5b\u00e6rsyltet\u00f8j");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"r\u00e4ksm\u00f6rg\u00e5s", (String)"r\u00e6ksm\u00f8rg\u00e5s");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"raeksm\u00f6rgaos", (String)"r\u00e6ksm\u00f8rg\u00e5s");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"raeksm\u00f6rgaas", (String)"r\u00e6ksm\u00f8rg\u00e5s");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"raeksmoerg\u00e5s", (String)"r\u00e6ksm\u00f8rg\u00e5s");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ab", (String)"ab");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ob", (String)"ob");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Ab", (String)"Ab");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Ob", (String)"Ob");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e5", (String)"\u00e5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aa", (String)"\u00e5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aA", (String)"\u00e5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ao", (String)"\u00e5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aO", (String)"\u00e5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"AA", (String)"\u00c5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Aa", (String)"\u00c5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Ao", (String)"\u00c5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"AO", (String)"\u00c5");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e6", (String)"\u00e6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00e4", (String)"\u00e6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00c6", (String)"\u00c6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00c4", (String)"\u00c6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"ae", (String)"\u00e6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"aE", (String)"\u00e6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Ae", (String)"\u00c6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"AE", (String)"\u00c6");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00f6", (String)"\u00f8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00f8", (String)"\u00f8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00d6", (String)"\u00d8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u00d8", (String)"\u00d8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"oo", (String)"\u00f8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"oe", (String)"\u00f8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"oO", (String)"\u00f8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"oE", (String)"\u00f8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Oo", (String)"\u00d8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"Oe", (String)"\u00d8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"OO", (String)"\u00d8");
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)this.analyzer, (String)"OE", (String)"\u00d8");
    }

    public void testEmptyTerm() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ScandinavianNormalizationFilter((TokenStream)tokenizer));
            }
        };
        TestScandinavianNormalizationFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    public void testRandomData() throws Exception {
        TestScandinavianNormalizationFilter.checkRandomData((Random)TestScandinavianNormalizationFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }
}

