/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharacterUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.util.TestUtil;

public class TestStemmerOverrideFilter
extends BaseTokenStreamTestCase {
    private KeywordTokenizer keywordTokenizer(String data) throws IOException {
        KeywordTokenizer tokenizer = new KeywordTokenizer();
        tokenizer.setReader((Reader)new StringReader(data));
        return tokenizer;
    }

    public void testOverride() throws IOException {
        StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder();
        builder.add((CharSequence)"booked", (CharSequence)"books");
        KeywordTokenizer tokenizer = this.keywordTokenizer("booked");
        PorterStemFilter stream = new PorterStemFilter((TokenStream)new StemmerOverrideFilter((TokenStream)tokenizer, builder.build()));
        TestStemmerOverrideFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"books"});
    }

    public void testIgnoreCase() throws IOException {
        StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(true);
        builder.add((CharSequence)"boOkEd", (CharSequence)"books");
        KeywordTokenizer tokenizer = this.keywordTokenizer("BooKeD");
        PorterStemFilter stream = new PorterStemFilter((TokenStream)new StemmerOverrideFilter((TokenStream)tokenizer, builder.build()));
        TestStemmerOverrideFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"books"});
    }

    public void testNoOverrides() throws IOException {
        StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(true);
        KeywordTokenizer tokenizer = this.keywordTokenizer("book");
        PorterStemFilter stream = new PorterStemFilter((TokenStream)new StemmerOverrideFilter((TokenStream)tokenizer, builder.build()));
        TestStemmerOverrideFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"book"});
    }

    public void testRandomRealisticWhiteSpace() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> seen = new HashSet<String>();
        int numTerms = TestStemmerOverrideFilter.atLeast((int)50);
        boolean ignoreCase = TestStemmerOverrideFilter.random().nextBoolean();
        for (int i = 0; i < numTerms; ++i) {
            String seenInputValue;
            int cp;
            String randomRealisticUnicodeString = TestUtil.randomRealisticUnicodeString((Random)TestStemmerOverrideFilter.random());
            char[] charArray = randomRealisticUnicodeString.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < charArray.length; j += Character.charCount(cp)) {
                cp = Character.codePointAt(charArray, j, charArray.length);
                if (Character.isWhitespace(cp)) continue;
                builder.appendCodePoint(cp);
            }
            if (builder.length() <= 0) continue;
            String inputValue = builder.toString();
            if (ignoreCase) {
                char[] buffer = inputValue.toCharArray();
                CharacterUtils.toLowerCase((char[])buffer, (int)0, (int)buffer.length);
                seenInputValue = buffer.toString();
            } else {
                seenInputValue = inputValue;
            }
            if (seen.contains(seenInputValue)) continue;
            seen.add(seenInputValue);
            String value = TestUtil.randomSimpleString((Random)TestStemmerOverrideFilter.random());
            map.put(inputValue, value.isEmpty() ? "a" : value);
        }
        if (map.isEmpty()) {
            map.put("booked", "books");
        }
        StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(ignoreCase);
        Set entrySet = map.entrySet();
        StringBuilder input = new StringBuilder();
        ArrayList<String> output = new ArrayList<String>();
        for (Map.Entry entry : entrySet) {
            builder.add((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            if (!TestStemmerOverrideFilter.random().nextBoolean() && !output.isEmpty()) continue;
            input.append((String)entry.getKey()).append(" ");
            output.add((String)entry.getValue());
        }
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer();
        tokenizer.setReader((Reader)new StringReader(input.toString()));
        PorterStemFilter stream = new PorterStemFilter((TokenStream)new StemmerOverrideFilter((TokenStream)tokenizer, builder.build()));
        TestStemmerOverrideFilter.assertTokenStreamContents((TokenStream)stream, (String[])output.toArray(new String[0]));
    }

    public void testRandomRealisticKeyword() throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int numTerms = TestStemmerOverrideFilter.atLeast((int)50);
        for (int i = 0; i < numTerms; ++i) {
            String randomRealisticUnicodeString = TestUtil.randomRealisticUnicodeString((Random)TestStemmerOverrideFilter.random());
            if (randomRealisticUnicodeString.length() <= 0) continue;
            String value = TestUtil.randomSimpleString((Random)TestStemmerOverrideFilter.random());
            map.put(randomRealisticUnicodeString, value.isEmpty() ? "a" : value);
        }
        if (map.isEmpty()) {
            map.put("booked", "books");
        }
        StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(false);
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            builder.add((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        StemmerOverrideFilter.StemmerOverrideMap build = builder.build();
        for (Map.Entry entry : entrySet) {
            if (!TestStemmerOverrideFilter.random().nextBoolean()) continue;
            KeywordTokenizer tokenizer = new KeywordTokenizer();
            tokenizer.setReader((Reader)new StringReader((String)entry.getKey()));
            PorterStemFilter stream = new PorterStemFilter((TokenStream)new StemmerOverrideFilter((TokenStream)tokenizer, build));
            TestStemmerOverrideFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{(String)entry.getValue()});
        }
    }
}

