/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.StringMockResourceLoader;
import org.apache.lucene.util.Version;

public class TestStemmerOverrideFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testKeywords() throws Exception {
        StringReader reader = new StringReader("testing dogs");
        MockTokenizer stream = TestStemmerOverrideFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("StemmerOverride", Version.LATEST, new StringMockResourceLoader("dogs\tcat"), "dictionary", "stemdict.txt").create((TokenStream)stream);
        stream = this.tokenFilterFactory("PorterStem", new String[0]).create((TokenStream)stream);
        TestStemmerOverrideFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"test", "cat"});
    }

    public void testKeywordsCaseInsensitive() throws Exception {
        StringReader reader = new StringReader("testing DoGs");
        MockTokenizer stream = TestStemmerOverrideFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("StemmerOverride", Version.LATEST, new StringMockResourceLoader("dogs\tcat"), "dictionary", "stemdict.txt", "ignoreCase", "true").create((TokenStream)stream);
        stream = this.tokenFilterFactory("PorterStem", new String[0]).create((TokenStream)stream);
        TestStemmerOverrideFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"test", "cat"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestStemmerOverrideFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("StemmerOverride", "bogusArg", "bogusValue"));
        TestStemmerOverrideFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

