/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class TestTrimFilter
extends BaseTokenStreamTestCase {
    public void testTrim() throws Exception {
        char[] a = " a ".toCharArray();
        char[] b = "b   ".toCharArray();
        char[] ccc = "cCc".toCharArray();
        char[] whitespace = "   ".toCharArray();
        char[] empty = "".toCharArray();
        IterTokenStream ts = new IterTokenStream(new Token((CharSequence)new String(a, 0, a.length), 1, 5), new Token((CharSequence)new String(b, 0, b.length), 6, 10), new Token((CharSequence)new String(ccc, 0, ccc.length), 11, 15), new Token((CharSequence)new String(whitespace, 0, whitespace.length), 16, 20), new Token((CharSequence)new String(empty, 0, empty.length), 21, 21));
        ts = new TrimFilter((TokenStream)ts);
        TestTrimFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"a", "b", "cCc", "", ""});
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.KEYWORD, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new TrimFilter((TokenStream)tokenizer));
            }
        };
        TestTrimFilter.checkRandomData((Random)TestTrimFilter.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new TrimFilter((TokenStream)tokenizer));
            }
        };
        TestTrimFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    @Deprecated
    private static class IterTokenStream
    extends TokenStream {
        final Token[] tokens;
        int index = 0;
        CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);

        public IterTokenStream(Token ... tokens) {
            this.tokens = tokens;
        }

        public boolean incrementToken() throws IOException {
            if (this.index >= this.tokens.length) {
                return false;
            }
            this.clearAttributes();
            Token token = this.tokens[this.index++];
            this.termAtt.setEmpty().append((CharTermAttribute)token);
            this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
            this.posIncAtt.setPositionIncrement(token.getPositionIncrement());
            this.flagsAtt.setFlags(token.getFlags());
            this.typeAtt.setType(token.type());
            this.payloadAtt.setPayload(token.getPayload());
            return true;
        }
    }
}

