/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestTrimFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testTrimming() throws Exception {
        StringReader reader = new StringReader("trim me    ");
        MockTokenizer stream = TestTrimFilterFactory.keywordMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Trim", new String[0]).create((TokenStream)stream);
        TestTrimFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"trim me"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestTrimFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Trim", "bogusArg", "bogusValue"));
        TestTrimFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

